/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.connect.client.ui.SharedPackageListingsSettings;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.admin.setup.SetupWizardActionBean;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamHotReloadContextKeeper;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.api.Framework;

@Name(value="appsViews")
@Scope(value=ScopeType.CONVERSATION)
public class AppCenterViewsManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(AppCenterViewsManager.class);
    private static final String LABEL_STUDIO_UPDATE_STATUS = "label.studio.update.status.";
    protected static final Map<String, String> view2PackageListName = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ConnectAppsUpdates", "updates");
            this.put("ConnectAppsStudio", "studio");
            this.put("ConnectAppsRemote", "remote");
            this.put("ConnectAppsLocal", "local");
        }
    };
    @In(create=true)
    protected String currentAdminSubViewId;
    @In(create=true)
    protected NuxeoSeamHotReloadContextKeeper seamReloadContext;
    @In(create=true)
    protected SetupWizardActionBean setupWizardAction;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected String searchString;
    protected SnapshotStatus studioSnapshotStatus;
    protected int studioSnapshotDownloadProgress;
    protected boolean isStudioSnapshopUpdateInProgress = false;
    protected String studioSnapshotUpdateError;
    protected Boolean validateStudioSnapshot;
    protected ValidationStatus studioSnapshotValidationStatus;
    private FileTime lastUpdate = null;

    public String getSearchString() {
        if (this.searchString == null) {
            return "";
        }
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public boolean getOnlyRemote() {
        return SharedPackageListingsSettings.instance().get("remote").isOnlyRemote();
    }

    public void setOnlyRemote(boolean onlyRemote) {
        SharedPackageListingsSettings.instance().get("remote").setOnlyRemote(onlyRemote);
    }

    protected String getListName() {
        return view2PackageListName.get(this.currentAdminSubViewId);
    }

    public void setPlatformFilter(boolean doFilter) {
        SharedPackageListingsSettings.instance().get(this.getListName()).setPlatformFilter(doFilter);
    }

    public boolean getPlatformFilter() {
        return SharedPackageListingsSettings.instance().get(this.getListName()).getPlatformFilter();
    }

    public String getPackageTypeFilter() {
        return SharedPackageListingsSettings.instance().get(this.getListName()).getPackageTypeFilter();
    }

    public void setPackageTypeFilter(String filter) {
        SharedPackageListingsSettings.instance().get(this.getListName()).setPackageTypeFilter(filter);
    }

    public List<SelectItem> getPackageTypes() {
        ArrayList<SelectItem> types = new ArrayList<SelectItem>();
        SelectItem allItem = new SelectItem((Object)"", "label.packagetype.all");
        types.add(allItem);
        for (PackageType ptype : PackageType.values()) {
            SelectItem item = new SelectItem((Object)ptype.getValue(), "label.packagetype." + ptype.getValue());
            types.add(item);
        }
        return types;
    }

    public void flushCache() {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        pm.flushCache();
    }

    public String installStudioSnapshotAndRedirect() throws Exception {
        this.installStudioSnapshot();
        return "view_admin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installStudioSnapshot() throws Exception {
        if (this.isStudioSnapshopUpdateInProgress) {
            return;
        }
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        List pkgs = pm.listAllStudioRemotePackages();
        DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
        this.studioSnapshotUpdateError = null;
        this.resetStudioSnapshotValidationStatus();
        if (snapshotPkg != null) {
            this.isStudioSnapshopUpdateInProgress = true;
            try {
                StudioAutoInstaller studioAutoInstaller = new StudioAutoInstaller(pm, snapshotPkg.getId(), this.shouldValidateStudioSnapshot());
                studioAutoInstaller.run();
            }
            finally {
                this.isStudioSnapshopUpdateInProgress = false;
            }
        } else {
            this.studioSnapshotUpdateError = AppCenterViewsManager.translate("label.studio.update.error.noSnapshotPackageFound", new Object[0]);
        }
    }

    public boolean isStudioSnapshopUpdateInProgress() {
        return this.isStudioSnapshopUpdateInProgress;
    }

    public Boolean getValidateStudioSnapshot() {
        return this.validateStudioSnapshot;
    }

    public void setValidateStudioSnapshot(Boolean validateStudioSnapshot) {
        this.validateStudioSnapshot = validateStudioSnapshot;
    }

    protected boolean shouldValidateStudioSnapshot() {
        if (Framework.isBooleanPropertyTrue((String)"studio.snapshot.disablePkgValidation")) {
            return false;
        }
        return Boolean.TRUE.equals(this.getValidateStudioSnapshot());
    }

    protected static String translate(String label, Object ... params) {
        return ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)label, (Object[])params);
    }

    protected FileTime getLastUpdateDate() {
        if (this.lastUpdate == null) {
            PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
            List pkgs = pm.listAllStudioRemotePackages();
            DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
            if (snapshotPkg != null) {
                try {
                    PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
                    LocalPackage pkg = pus.getPackage(snapshotPkg.getId());
                    if (pkg != null) {
                        this.lastUpdate = pus.getInstallDate(pkg.getId());
                    }
                }
                catch (PackageException e) {
                    log.error((Object)e);
                }
            }
            return this.lastUpdate;
        }
        return this.lastUpdate;
    }

    public String getStudioInstallationStatus() {
        if (this.studioSnapshotStatus == null) {
            PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
            List pkgs = pm.listAllStudioRemotePackages();
            LocalPackage pkg = null;
            DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
            if (snapshotPkg != null) {
                try {
                    PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
                    pkg = pus.getPackage(snapshotPkg.getId());
                }
                catch (PackageException e) {
                    log.error((Object)e);
                }
            }
            if (pkg == null) {
                return AppCenterViewsManager.translate("label.studio.update.status.noStatus", new Object[0]);
            }
            PackageState studioPkgState = PackageState.getByValue((int)pkg.getState());
            this.studioSnapshotStatus = studioPkgState == PackageState.DOWNLOADING ? SnapshotStatus.downloading : (studioPkgState == PackageState.DOWNLOADED ? SnapshotStatus.saving : (studioPkgState == PackageState.INSTALLING ? SnapshotStatus.installing : (studioPkgState.isInstalled() ? SnapshotStatus.completed : SnapshotStatus.error)));
        }
        Object[] params = new Object[]{};
        if (SnapshotStatus.error.equals((Object)this.studioSnapshotStatus)) {
            if (this.studioSnapshotUpdateError == null) {
                this.studioSnapshotUpdateError = "???";
            }
            params = new Object[]{this.studioSnapshotUpdateError};
        } else if (SnapshotStatus.downloading.equals((Object)this.studioSnapshotStatus)) {
            params = new Object[]{String.valueOf(this.studioSnapshotDownloadProgress)};
        } else {
            FileTime update = this.getLastUpdateDate();
            if (update != null) {
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                df.setTimeZone(TimeZone.getDefault());
                params = new Object[]{df.format(new Date(update.toMillis()))};
            }
        }
        return AppCenterViewsManager.translate(LABEL_STUDIO_UPDATE_STATUS + this.studioSnapshotStatus.name(), params);
    }

    protected void setStatus(SnapshotStatus status, String errorMessage) {
        this.studioSnapshotStatus = status;
        this.studioSnapshotUpdateError = errorMessage;
    }

    protected void setStatus(SnapshotStatus status, String errorMessage, ValidationStatus validationStatus) {
        this.setStatus(status, errorMessage);
        this.setStudioSnapshotValidationStatus(validationStatus);
    }

    public ValidationStatus getStudioSnapshotValidationStatus() {
        return this.studioSnapshotValidationStatus;
    }

    public void setStudioSnapshotValidationStatus(ValidationStatus status) {
        this.studioSnapshotValidationStatus = status;
    }

    public void resetStudioSnapshotValidationStatus() {
        this.setStudioSnapshotValidationStatus(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDevMode(boolean value) {
        String feedbackCompId = "changeDevModeForm";
        ConfigurationGenerator conf = this.setupWizardAction.getConfigurationGenerator();
        boolean configurable = conf.isConfigurable();
        if (!configurable) {
            this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.ERROR, AppCenterViewsManager.translate("label.setup.nuxeo.org.nuxeo.dev.changingDevModeNotConfigurable", new Object[0]), new Object[0]);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.nuxeo.dev", Boolean.toString(value));
        try {
            conf.saveFilteredConfiguration(params);
            Properties props = conf.getUserConfig();
            conf.getServerConfigurator().dumpProperties(props);
            Framework.getRuntime().reloadProperties();
            if (value) {
                this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.WARN, AppCenterViewsManager.translate("label.admin.center.devMode.justActivated", new Object[0]), new Object[0]);
            } else {
                this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.INFO, AppCenterViewsManager.translate("label.admin.center.devMode.justDisabled", new Object[0]), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.ERROR, AppCenterViewsManager.translate("label.admin.center.devMode.errorSaving", e.getMessage()), new Object[0]);
        }
        finally {
            this.setupWizardAction.setNeedsRestart(true);
            this.setupWizardAction.resetParameters();
        }
    }

    protected class StudioAutoInstaller
    implements Runnable {
        protected final String packageId;
        protected final PackageManager pm;
        protected final boolean validate;

        protected StudioAutoInstaller(PackageManager pm, String packageId, boolean validate) {
            this.pm = pm;
            this.packageId = packageId;
            this.validate = validate;
        }

        @Override
        public void run() {
            block25: {
                try {
                    if (this.validate) {
                        ValidationStatus status = new ValidationStatus();
                        this.pm.flushCache();
                        DownloadablePackage remotePkg = this.pm.findRemotePackageById(this.packageId);
                        if (remotePkg == null) {
                            status.addError(String.format("Cannot perform validation: remote package '%s' not found", this.packageId));
                            return;
                        }
                        String[] targetPlatforms = remotePkg.getTargetPlatforms();
                        PackageDependency[] pkgDeps = remotePkg.getDependencies();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("%s target platforms: %s", remotePkg, ArrayUtils.toString((Object)targetPlatforms)));
                            log.debug((Object)String.format("%s dependencies: %s", remotePkg, ArrayUtils.toString((Object)pkgDeps)));
                        }
                        if (!PlatformVersionHelper.isCompatible(targetPlatforms)) {
                            status.addError(String.format("This package is not validated for your current platform: %s", PlatformVersionHelper.getPlatformFilter()));
                        }
                        if (pkgDeps != null && pkgDeps.length > 0) {
                            DependencyResolution resolution = this.pm.resolveDependencies(this.packageId, PlatformVersionHelper.getPlatformFilter());
                            if (resolution.isFailed() && PlatformVersionHelper.getPlatformFilter() != null) {
                                resolution = this.pm.resolveDependencies(this.packageId, null);
                            }
                            if (resolution.isFailed()) {
                                status.addError(String.format("Dependency check has failed for package '%s' (%s)", this.packageId, resolution));
                            } else {
                                List pkgToInstall = resolution.getInstallPackageIds();
                                if ((pkgToInstall == null || pkgToInstall.size() != 1 || !this.packageId.equals(pkgToInstall.get(0))) && resolution.requireChanges()) {
                                    status.addError(resolution.toString().trim().replaceAll("\n", "<br />"));
                                }
                            }
                        }
                        if (status.hasErrors()) {
                            AppCenterViewsManager.this.setStatus(SnapshotStatus.error, AppCenterViewsManager.translate("label.studio.update.validation.error", new Object[0]), status);
                            return;
                        }
                    }
                    if (Framework.isDevModeSet()) {
                        try {
                            PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
                            LocalPackage pkg = pus.getPackage(this.packageId);
                            if (pkg != null) {
                                log.info((Object)String.format("Updating package %s...", pkg));
                                if (PackageState.getByValue((int)pkg.getState()).isInstalled()) {
                                    log.info((Object)("Uninstalling " + this.packageId));
                                    Task uninstallTask = pkg.getUninstallTask();
                                    try {
                                        this.performTask(uninstallTask);
                                    }
                                    catch (PackageException e) {
                                        uninstallTask.rollback();
                                        throw e;
                                    }
                                }
                                pus.removePackage(this.packageId);
                            }
                            AppCenterViewsManager.this.setStatus(SnapshotStatus.downloading, null);
                            DownloadingPackage downloadingPkg = this.pm.download(this.packageId);
                            try {
                                while (!downloadingPkg.isCompleted()) {
                                    AppCenterViewsManager.this.studioSnapshotDownloadProgress = downloadingPkg.getDownloadProgress();
                                    Thread.sleep(100L);
                                    log.debug((Object)"downloading studio snapshot package");
                                }
                                log.debug((Object)"studio snapshot package download completed, starting installation");
                                Thread.sleep(200L);
                                AppCenterViewsManager.this.setStatus(SnapshotStatus.saving, null);
                                while (pus.getPackage(downloadingPkg.getId()) == null) {
                                    AppCenterViewsManager.this.studioSnapshotDownloadProgress = downloadingPkg.getDownloadProgress();
                                    Thread.sleep(50L);
                                    log.debug((Object)"downloading studio snapshot package");
                                }
                            }
                            catch (InterruptedException | PackageException e) {
                                log.error((Object)"Error while downloading studio snapshot", e);
                                AppCenterViewsManager.this.setStatus(SnapshotStatus.error, AppCenterViewsManager.translate("label.studio.update.downloading.error", e.getMessage()));
                                return;
                            }
                            AppCenterViewsManager.this.setStatus(SnapshotStatus.installing, null);
                            log.info((Object)("Installing " + this.packageId));
                            pkg = pus.getPackage(this.packageId);
                            Task installTask = pkg.getInstallTask();
                            try {
                                this.performTask(installTask);
                            }
                            catch (PackageException e) {
                                installTask.rollback();
                                throw e;
                            }
                            pkg = pus.getPackage(this.packageId);
                            AppCenterViewsManager.this.lastUpdate = pus.getInstallDate(this.packageId);
                            AppCenterViewsManager.this.setStatus(SnapshotStatus.completed, null);
                        }
                        catch (PackageException e) {
                            log.error((Object)"Error while installing studio snapshot", (Throwable)e);
                            AppCenterViewsManager.this.setStatus(SnapshotStatus.error, AppCenterViewsManager.translate("label.studio.update.installation.error", e.getMessage()));
                        }
                        break block25;
                    }
                    InstallAfterRestart.addPackageForInstallation(this.packageId);
                    AppCenterViewsManager.this.setStatus(SnapshotStatus.restartNeeded, null);
                    AppCenterViewsManager.this.setupWizardAction.setNeedsRestart(true);
                }
                catch (Exception e) {
                    AppCenterViewsManager.this.setStatus(SnapshotStatus.error, e.getMessage());
                }
            }
        }

        protected void performTask(Task task) throws PackageException {
            ValidationStatus validationStatus = task.validate();
            if (validationStatus.hasErrors()) {
                throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
            }
            if (validationStatus.hasWarnings()) {
                log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + validationStatus.getWarnings()));
            }
            task.run(null);
        }
    }

    protected static enum SnapshotStatus {
        downloading,
        saving,
        installing,
        error,
        completed,
        restartNeeded;

    }
}

