/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.metadata;

import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.VersionRange;

public class RequiredCapability
implements IRequiredCapability {
    private final String name;
    private final VersionRange range;
    private boolean optional;
    private int arity;

    public RequiredCapability(String name, VersionRange range) {
        this.name = name;
        this.range = range == null ? VersionRange.emptyRange : range;
    }

    public RequiredCapability(String name, VersionRange range, boolean optional) {
        this(name, range);
        this.optional = optional;
    }

    public RequiredCapability(String name, VersionRange range, int arity) {
        this(name, range);
        this.arity = arity;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IRequiredCapability)) {
            return false;
        }
        IRequiredCapability other = (IRequiredCapability)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        return this.range.equals(other.getRange());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VersionRange getRange() {
        return this.range;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.range.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        result.append(' ');
        if (this.range.getMinimum().equals(this.range.getMaximum())) {
            result.append('[').append(this.range.getMinimum()).append(']');
        } else {
            result.append(this.range);
        }
        return result.toString();
    }

    @Override
    public boolean isNegation() {
        return false;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public void setArity(int arity) {
        this.arity = arity;
    }
}

