/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingWorkflowInstancesCleanup
implements EventListener {
    public static final String CLEANUP_WORKFLOW_INSTANCES_PROPERTY = "nuxeo.routing.disable.cleanup.workflow.instances";
    public static final String CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY = "nuxeo.routing.cleanup.workflow.instances.batch.size";

    public void handleEvent(Event event) throws ClientException {
        if (!"workflowInstancesCleanup".equals(event.getName()) || Framework.isBooleanPropertyTrue((String)CLEANUP_WORKFLOW_INSTANCES_PROPERTY)) {
            return;
        }
        int batchSize = Integer.parseInt(Framework.getProperty((String)CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY, (String)"100"));
        for (RepositoryManagement repoMgmt : RepositoryResolver.getRepositories()) {
            ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).cleanupDoneAndCanceledRouteInstances(repoMgmt.getName(), batchSize);
        }
    }
}

