/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.DisjunctionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.Enumerator;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEvaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.LeafEvaluator;
import org.apache.directory.server.core.partition.impl.btree.ScopeEnumerator;
import org.apache.directory.server.core.partition.impl.btree.SubstringEnumerator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class ExpressionEnumerator
implements Enumerator {
    private BTreePartition db = null;
    private ScopeEnumerator scopeEnumerator;
    private SubstringEnumerator substringEnumerator;
    private ExpressionEvaluator evaluator;

    public ExpressionEnumerator(BTreePartition db, AttributeTypeRegistry attributeTypeRegistry, ExpressionEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
        LeafEvaluator leafEvaluator = evaluator.getLeafEvaluator();
        this.scopeEnumerator = new ScopeEnumerator(db, leafEvaluator.getScopeEvaluator());
        this.substringEnumerator = new SubstringEnumerator(db, attributeTypeRegistry, leafEvaluator.getSubstringEvaluator());
    }

    public NamingEnumeration enumerate(ExprNode node) throws NamingException {
        NamingEnumeration list = null;
        if (node instanceof ScopeNode) {
            list = this.scopeEnumerator.enumerate(node);
        } else {
            if (node instanceof AssertionNode) {
                throw new IllegalArgumentException("Cannot produce enumeration on an AssertionNode");
            }
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                switch (leaf.getAssertionType()) {
                    case APPROXIMATE: {
                        list = this.enumEquality((SimpleNode)node);
                        break;
                    }
                    case EQUALITY: {
                        list = this.enumEquality((SimpleNode)node);
                        break;
                    }
                    case EXTENSIBLE: {
                        throw new NotImplementedException();
                    }
                    case GREATEREQ: {
                        list = this.enumGreater((SimpleNode)node, true);
                        break;
                    }
                    case LESSEQ: {
                        list = this.enumGreater((SimpleNode)node, false);
                        break;
                    }
                    case PRESENCE: {
                        list = this.enumPresence((PresenceNode)node);
                        break;
                    }
                    case SUBSTRING: {
                        list = this.substringEnumerator.enumerate((ExprNode)leaf);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown leaf assertion");
                    }
                }
            } else {
                BranchNode branch = (BranchNode)node;
                switch (branch.getOperator()) {
                    case AND: {
                        list = this.enumConj(branch);
                        break;
                    }
                    case NOT: {
                        list = this.enumNeg(branch);
                        break;
                    }
                    case OR: {
                        list = this.enumDisj(branch);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown branch logical operator");
                    }
                }
            }
        }
        return list;
    }

    private NamingEnumeration enumDisj(BranchNode node) throws NamingException {
        List children = node.getChildren();
        NamingEnumeration[] childEnumerations = new NamingEnumeration[children.size()];
        for (int ii = 0; ii < childEnumerations.length; ++ii) {
            childEnumerations[ii] = this.enumerate((ExprNode)children.get(ii));
        }
        return new DisjunctionEnumeration(childEnumerations);
    }

    private NamingEnumeration enumNeg(final BranchNode node) throws NamingException {
        IndexEnumeration baseEnumeration = null;
        IndexAssertionEnumeration enumeration = null;
        baseEnumeration = this.db.getNdnIndex().listIndices();
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                return !ExpressionEnumerator.this.evaluator.evaluate(node.getChild(), rec);
            }
        };
        enumeration = new IndexAssertionEnumeration((NamingEnumeration)baseEnumeration, assertion, true);
        return enumeration;
    }

    private NamingEnumeration enumConj(BranchNode node) throws NamingException {
        int minIndex = 0;
        long minValue = Long.MAX_VALUE;
        long value = Long.MAX_VALUE;
        final List children = node.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            value = (Long)child.get((Object)"count");
            if ((minValue = Math.min(minValue, value)) != value) continue;
            minIndex = ii;
        }
        final ExprNode minChild = (ExprNode)children.get(minIndex);
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                for (int ii = 0; ii < children.size(); ++ii) {
                    ExprNode child = (ExprNode)children.get(ii);
                    if (child == minChild || ExpressionEnumerator.this.evaluator.evaluate(child, rec)) continue;
                    return false;
                }
                return true;
            }
        };
        NamingEnumeration underlying = this.enumerate(minChild);
        IndexAssertionEnumeration iae = new IndexAssertionEnumeration(underlying, assertion);
        return iae;
    }

    private NamingEnumeration enumPresence(PresenceNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getExistanceIndex();
            return idx.listIndices((Object)node.getAttribute());
        }
        return this.nonIndexedScan((LeafNode)node);
    }

    private NamingEnumeration enumGreater(SimpleNode node, boolean isGreater) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            if (isGreater) {
                return idx.listIndices(node.getValue(), true);
            }
            return idx.listIndices(node.getValue(), false);
        }
        return this.nonIndexedScan((LeafNode)node);
    }

    private NamingEnumeration enumEquality(SimpleNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.listIndices(node.getValue());
        }
        return this.nonIndexedScan((LeafNode)node);
    }

    private NamingEnumeration nonIndexedScan(final LeafNode node) throws NamingException {
        IndexEnumeration underlying = this.db.getNdnIndex().listIndices();
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord record) throws NamingException {
                return ExpressionEnumerator.this.evaluator.getLeafEvaluator().evaluate((ExprNode)node, record);
            }
        };
        return new IndexAssertionEnumeration((NamingEnumeration)underlying, assertion);
    }
}

