/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.schema.MetaSchemaUtils;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaChangeHandler;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaChangeHandler
implements SchemaChangeHandler {
    protected final Registries targetRegistries;
    protected final PartitionSchemaLoader loader;
    protected final AttributeType m_oidAT;
    protected final SchemaEntityFactory factory;

    protected AbstractSchemaChangeHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws NamingException {
        this.targetRegistries = targetRegistries;
        this.loader = loader;
        this.m_oidAT = targetRegistries.getAttributeTypeRegistry().lookup("m-oid");
        this.factory = new SchemaEntityFactory(targetRegistries);
    }

    protected void checkOidIsUnique(Attributes entry) throws NamingException {
        String oid = this.getOid(entry);
        if (this.targetRegistries.getOidRegistry().hasOid(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema entity is not unique.", ResultCodeEnum.OTHER);
        }
    }

    protected void checkOidIsUnique(SchemaObject schemaObject) throws NamingException {
        String oid = schemaObject.getOid();
        if (this.targetRegistries.getOidRegistry().hasOid(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema entity is not unique.", ResultCodeEnum.OTHER);
        }
    }

    protected void checkOidIsUnique(String oid) throws NamingException {
        if (this.targetRegistries.getOidRegistry().hasOid(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema entity is not unique.", ResultCodeEnum.OTHER);
        }
    }

    protected abstract void modify(LdapDN var1, Attributes var2, Attributes var3, boolean var4) throws NamingException;

    @Override
    public final void modify(LdapDN name, int modOp, Attributes mods, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        this.modify(name, entry, targetEntry, cascade);
    }

    @Override
    public final void modify(LdapDN name, ModificationItemImpl[] mods, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        this.modify(name, entry, targetEntry, cascade);
    }

    protected Set<String> getOids(Set<SearchResult> results) throws NamingException {
        HashSet<String> oids = new HashSet<String>(results.size());
        for (SearchResult result : results) {
            LdapDN dn = new LdapDN(result.getName());
            dn.normalize(this.targetRegistries.getAttributeTypeRegistry().getNormalizerMapping());
            oids.add((String)dn.getRdn().getValue());
        }
        return oids;
    }

    protected String getOid(Attributes entry) throws NamingException {
        Attribute oid = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.m_oidAT);
        if (oid == null) {
            return null;
        }
        return (String)oid.get();
    }

    protected String getSchemaName(LdapDN name) throws NamingException {
        return MetaSchemaUtils.getSchemaName(name);
    }

    protected Schema getSchema(LdapDN name) throws NamingException {
        return this.loader.getSchema(MetaSchemaUtils.getSchemaName(name));
    }

    protected void unregisterOids(String oid) throws NamingException {
        this.targetRegistries.getOidRegistry().unregister(oid);
    }

    protected void registerOids(SchemaObject obj) throws NamingException {
        String[] names = obj.getNames();
        if (names != null) {
            for (String name : names) {
                this.targetRegistries.getOidRegistry().register(name, obj.getOid());
            }
        }
        this.targetRegistries.getOidRegistry().register(obj.getOid(), obj.getOid());
    }
}

