/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.util.Strings;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class Renderer {
    final StringBuilder out;
    final boolean asXml;
    final boolean isAsciiOnly;
    private static final String HTML_NS;
    private static final boolean[] CASE_SENS_NAME_CHARS;
    private static final boolean[] CASE_INSENS_NAME_CHARS;

    Renderer(StringBuilder out, boolean asXml, boolean isAsciiOnly) {
        this.out = out;
        this.asXml = asXml;
        this.isAsciiOnly = isAsciiOnly;
    }

    void render(Node node, Namespaces ns) {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
                    this.render(c, ns);
                }
                break;
            }
            case 1: {
                Node c;
                boolean isHtml;
                Namespaces elNs;
                boolean addElNs;
                Element el = (Element)node;
                this.out.append('<');
                int tagNameStart = this.out.length();
                String nsUri = el.getNamespaceURI();
                if (nsUri == null) {
                    nsUri = HTML_NS;
                }
                boolean bl = addElNs = (elNs = ns.forUri(nsUri)) == null;
                if (addElNs) {
                    elNs = ns = this.addNamespace(ns, nsUri);
                }
                if (elNs.prefix.length() != 0) {
                    this.out.append(elNs.prefix).append(':');
                }
                String localName = el.getLocalName();
                boolean bl2 = isHtml = elNs.uri == HTML_NS;
                if (isHtml) {
                    localName = Strings.toLowerCase(localName);
                }
                this.out.append(localName);
                int tagNameEnd = this.out.length();
                if (addElNs) {
                    this.out.append(' ');
                    this.renderNamespace(elNs);
                }
                NamedNodeMap attrs = el.getAttributes();
                int n = attrs.getLength();
                for (int i = 0; i < n; ++i) {
                    this.out.append(' ');
                    Attr a = (Attr)attrs.item(i);
                    String attrUri = a.getNamespaceURI();
                    if (attrUri != null && (attrUri = attrUri.intern()) != elNs.uri) {
                        Namespaces attrNs = ns.forUri(attrUri);
                        if (attrNs == null) {
                            attrNs = ns = this.addNamespace(ns, elNs.uri);
                            this.renderNamespace(attrNs);
                            this.out.append(' ');
                        }
                        this.out.append(attrNs.prefix).append(':');
                    }
                    this.renderAttr(a, HTML_NS.equals(attrUri));
                }
                HtmlTextEscapingMode m = this.asXml || !isHtml ? HtmlTextEscapingMode.PCDATA : HtmlTextEscapingMode.getModeForTag(localName);
                Node first = el.getFirstChild();
                if (first == null && (this.asXml || m == HtmlTextEscapingMode.VOID)) {
                    this.out.append(" />");
                    break;
                }
                this.out.append('>');
                if (!this.asXml) {
                    if (m == HtmlTextEscapingMode.CDATA || m == HtmlTextEscapingMode.PLAIN_TEXT) {
                        StringBuilder cdataContent = new StringBuilder();
                        for (Node c2 = first; c2 != null; c2 = c2.getNextSibling()) {
                            switch (c2.getNodeType()) {
                                case 3: 
                                case 4: {
                                    cdataContent.append(c2.getNodeValue());
                                }
                            }
                        }
                        if (Renderer.containsEndTag(cdataContent)) {
                            String lcaseContent = Strings.toLowerCase(cdataContent.toString());
                            int p = 1;
                            while ((p = lcaseContent.indexOf(localName, p + 1)) >= 0) {
                                if (!lcaseContent.regionMatches(p - 2, "</", 0, 2)) continue;
                                throw new IllegalStateException("XML document not renderable as HTML due to </" + localName + " in CDATA tag");
                            }
                        }
                        this.out.append((CharSequence)cdataContent);
                    } else {
                        for (c = first; c != null; c = c.getNextSibling()) {
                            this.render(c, ns);
                        }
                    }
                } else {
                    for (c = first; c != null; c = c.getNextSibling()) {
                        this.render(c, ns);
                    }
                }
                this.out.append("</").append(this.out, tagNameStart, tagNameEnd).append('>');
                break;
            }
            case 3: {
                Escaping.escapeXml((CharSequence)node.getNodeValue(), this.isAsciiOnly, this.out);
                break;
            }
            case 4: {
                String value = node.getNodeValue();
                if (this.asXml && !value.contains("]]>")) {
                    this.out.append("<![CDATA[");
                    this.out.append(value);
                    this.out.append("]]>");
                    break;
                }
                Escaping.escapeXml((CharSequence)value, this.isAsciiOnly, this.out);
                break;
            }
            case 2: {
                Attr a = (Attr)node;
                this.renderAttr(a, HTML_NS.equals(a.getNamespaceURI()));
                break;
            }
        }
    }

    private Namespaces addNamespace(Namespaces base, String uri) {
        int depth = 0;
        Namespaces p = base;
        while (p != null) {
            ++depth;
            p = p.parent;
        }
        return new Namespaces(base, "_ns" + depth, uri);
    }

    private void renderNamespace(Namespaces ns) {
        this.out.append("xmlns:").append(ns.prefix).append("=\"");
        Escaping.escapeXml((CharSequence)ns.uri, this.isAsciiOnly, this.out);
        this.out.append('\"');
    }

    private void renderAttr(Attr a, boolean isHtml) {
        this.emitLocalName(a.getLocalName(), isHtml);
        this.out.append("=\"");
        Escaping.escapeXml((CharSequence)a.getValue(), this.isAsciiOnly, this.out);
        this.out.append("\"");
    }

    private void emitLocalName(String name, boolean isHtml) {
        boolean[] simple = isHtml ? CASE_INSENS_NAME_CHARS : CASE_SENS_NAME_CHARS;
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if (ch <= 'z' && simple[ch]) continue;
            if (isHtml) {
                name = Strings.toLowerCase(name);
            }
            Escaping.escapeXml((CharSequence)name, this.isAsciiOnly, this.out);
            return;
        }
        this.out.append(name);
    }

    private static boolean containsEndTag(StringBuilder sb) {
        int n = sb.length();
        block4: for (int i = 0; i < n; i += 2) {
            switch (sb.charAt(i)) {
                case '<': {
                    if (i + 1 >= n || sb.charAt(i + 1) != '/') continue block4;
                    return true;
                }
                case '/': {
                    if (i <= 0 || sb.charAt(i - 1) != '<') continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        int ch;
        HTML_NS = Namespaces.HTML_NAMESPACE_URI;
        CASE_SENS_NAME_CHARS = new boolean[123];
        CASE_INSENS_NAME_CHARS = new boolean[123];
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            Renderer.CASE_INSENS_NAME_CHARS[ch] = true;
            Renderer.CASE_SENS_NAME_CHARS[ch] = true;
        }
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            Renderer.CASE_INSENS_NAME_CHARS[ch] = true;
            Renderer.CASE_SENS_NAME_CHARS[ch] = true;
        }
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            Renderer.CASE_SENS_NAME_CHARS[ch] = true;
        }
    }
}

