/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.CssRuleRewriter;
import com.google.caja.plugin.templates.JsConcatenator;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SafeCssMaker {
    private final Node safeHtml;
    private final Block safeJs;
    private final List<CssTree.StyleSheet> validatedStylesheets;

    SafeCssMaker(Node safeHtml, Block safeJs, List<CssTree.StyleSheet> validatedStylesheets) {
        this.safeHtml = safeHtml;
        this.safeJs = safeJs;
        this.validatedStylesheets = validatedStylesheets;
    }

    void make() {
        if (this.validatedStylesheets.isEmpty()) {
            return;
        }
        ArrayList<Expression> cssParts = new ArrayList<Expression>();
        StringBuilder css = new StringBuilder();
        FilePosition staticPos = null;
        FilePosition dynamicPos = null;
        for (CssTree.StyleSheet ss : this.validatedStylesheets) {
            ArrayConstructor ac = CssRuleRewriter.cssToJs(ss);
            List<? extends Expression> children = ac.children();
            if (children.isEmpty()) continue;
            FilePosition acPos = ac.getFilePosition();
            Expression child0 = children.get(0);
            if (children.size() == 1 && child0 instanceof StringLiteral) {
                css.append('\n').append(((StringLiteral)child0).getUnquotedValue());
                staticPos = staticPos == null ? acPos : FilePosition.span(staticPos, acPos);
                continue;
            }
            int n = cssParts.size();
            if (n == 0) {
                cssParts.addAll(children);
            } else {
                JsConcatenator cat = new JsConcatenator();
                cat.append((Expression)cssParts.get(n - 1));
                cat.append(FilePosition.startOf(child0.getFilePosition()), "\n");
                cat.append(child0);
                cssParts.set(n - 1, cat.toExpression(false));
                cssParts.addAll(children.subList(1, children.size()));
            }
            dynamicPos = dynamicPos == null ? acPos : FilePosition.span(dynamicPos, acPos);
        }
        if (!cssParts.isEmpty()) {
            Statement firstChild = this.safeJs.children().isEmpty() ? null : this.safeJs.children().get(0);
            this.safeJs.insertBefore(new ExpressionStmt(dynamicPos, (Expression)QuasiBuilder.substV("IMPORTS___.emitCss___(@cssParts./*@synthetic*/join(IMPORTS___.getIdClass___()))", "cssParts", new ArrayConstructor(dynamicPos, cssParts))), firstChild);
        }
        Node safeHtml = this.safeHtml;
        if (css.length() != 0) {
            Document doc = safeHtml.getOwnerDocument();
            String nsUri = Namespaces.HTML_NAMESPACE_URI;
            Element style = doc.createElementNS(nsUri, "style");
            style.setAttributeNS(nsUri, "type", "text/css");
            style.appendChild(doc.createTextNode(css.toString()));
            Nodes.setFilePositionFor(style, dynamicPos);
            if (!(safeHtml instanceof DocumentFragment)) {
                DocumentFragment f = doc.createDocumentFragment();
                f.appendChild(safeHtml);
                safeHtml = f;
            }
            safeHtml.insertBefore(style, safeHtml.getFirstChild());
        }
    }
}

