/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

class ContentUrlHandler
extends URLStreamHandler {
    ContentUrlHandler() {
    }

    protected URLConnection openConnection(URL url) {
        return new URLConnection(url){
            private InputStream instream;

            public void connect() {
                URI uri;
                if (this.connected) {
                    return;
                }
                this.connected = true;
                try {
                    uri = this.url.toURI();
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                    return;
                }
                assert (uri.isOpaque());
                try {
                    this.instream = new ByteArrayInputStream(uri.getSchemeSpecificPart().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"UTF-8 not supported"))).initCause(ex));
                }
            }

            public InputStream getInputStream() {
                if (this.instream == null) {
                    throw new IllegalStateException();
                }
                return this.instream;
            }
        };
    }
}

