/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.Arrays;
import java.util.Collection;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;

@Operation(id="Context.RunOperationOnList", category="Execution Flow", label="Run For Each", description="Run an operation for each element from the list defined by the 'list' parameter. The 'list' parameter is pointing to a context variable that represents the list which will be iterated. The 'item' parameter represents the name of the context variable which will point to the current element in the list at each iteration. You can use the 'isolate' parameter to specify whether or not the evalution context is the same as the parent context or a copy of it. If the 'isolate' parameter is 'true' then a copy of the current context is used and so that modifications in this context will not affect the parent context. Any input is accepted. The input is returned back as output when operation terminates. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.")
public class RunOperationOnList {
    public static final String ID = "Context.RunOperationOnList";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="list")
    protected String listName;
    @Param(name="item", required=false, values={"item"})
    protected String itemName = "item";
    @Param(name="isolate", required=false, values={"true"})
    protected boolean isolate = true;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters;

    @OperationMethod
    public void run() throws Exception {
        OperationContext subctx = this.ctx.getSubContext(this.isolate, this.ctx.getInput());
        Collection<Object> list = null;
        if (this.ctx.get(this.listName) instanceof Object[]) {
            list = Arrays.asList((Object[])this.ctx.get(this.listName));
        } else if (this.ctx.get(this.listName) instanceof Collection) {
            list = (Collection)this.ctx.get(this.listName);
        } else {
            throw new UnsupportedOperationException(this.ctx.get(this.listName).getClass() + " is not a Collection");
        }
        for (Object e : list) {
            subctx.put(this.itemName, e);
            this.service.run(subctx, this.chainId, this.chainParameters);
        }
    }
}

