/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.traces;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Traces.ToggleRecording", category="Execution Context", label="Traces.toggleRecording", description="Toggle Automation call tracing (you can set the 'enableTrace' parameter if you want to explicitly set the traceEnable value")
public class AutomationTraceToggleOperation {
    public static final String ID = "Traces.ToggleRecording";
    @Param(name="enableTrace", required=false)
    protected Boolean enableTrace = null;
    @Context
    protected OperationContext ctx;

    protected boolean canManageTraces() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
        return principal != null && principal.isAdministrator();
    }

    @OperationMethod
    public boolean run() {
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        if (this.canManageTraces()) {
            if (this.enableTrace == null) {
                tracerFactory.toggleRecording();
            } else if (this.enableTrace.booleanValue() != tracerFactory.getRecordingState()) {
                tracerFactory.toggleRecording();
            }
        }
        return tracerFactory.getRecordingState();
    }
}

