/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.tiff.JpegImageData;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.constants.TagConstantsUtils;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.constants.TiffDirectoryConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.write.ImageDataOffsets;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputItem;
import org.apache.sanselan.formats.tiff.write.TiffOutputSummary;

public final class TiffOutputDirectory
extends TiffOutputItem
implements TiffConstants {
    public final int type;
    private final ArrayList fields = new ArrayList();
    private TiffOutputDirectory nextDirectory = null;
    private JpegImageData jpegImageData = null;
    private TiffImageData tiffImageData = null;

    public void setNextDirectory(TiffOutputDirectory nextDirectory) {
        this.nextDirectory = nextDirectory;
    }

    public TiffOutputDirectory(int type) {
        this.type = type;
    }

    public void add(TiffOutputField field) {
        this.fields.add(field);
    }

    public ArrayList getFields() {
        return new ArrayList(this.fields);
    }

    public void removeField(TagInfo tagInfo) {
        this.removeField(tagInfo.tag);
    }

    public void removeField(int tag) {
        ArrayList<TiffOutputField> matches = new ArrayList<TiffOutputField>();
        for (int i = 0; i < this.fields.size(); ++i) {
            TiffOutputField field = (TiffOutputField)this.fields.get(i);
            if (field.tag != tag) continue;
            matches.add(field);
        }
        this.fields.removeAll(matches);
    }

    public TiffOutputField findField(TagInfo tagInfo) {
        return this.findField(tagInfo.tag);
    }

    public TiffOutputField findField(int tag) {
        for (int i = 0; i < this.fields.size(); ++i) {
            TiffOutputField field = (TiffOutputField)this.fields.get(i);
            if (field.tag != tag) continue;
            return field;
        }
        return null;
    }

    public void sortFields() {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                TiffOutputField e1 = (TiffOutputField)o1;
                TiffOutputField e2 = (TiffOutputField)o2;
                if (e1.tag != e2.tag) {
                    return e1.tag - e2.tag;
                }
                return e1.getSortHint() - e2.getSortHint();
            }
        };
        Collections.sort(this.fields, comparator);
    }

    public String description() {
        return TiffDirectory.description(this.type);
    }

    public void writeItem(BinaryOutputStream bos) throws IOException, ImageWriteException {
        bos.write2Bytes(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            TiffOutputField field = (TiffOutputField)this.fields.get(i);
            field.writeField(bos);
        }
        int nextDirectoryOffset = 0;
        if (this.nextDirectory != null) {
            nextDirectoryOffset = this.nextDirectory.getOffset();
        }
        if (nextDirectoryOffset == -1) {
            bos.write4Bytes(0);
        } else {
            bos.write4Bytes(nextDirectoryOffset);
        }
    }

    public void setJpegImageData(JpegImageData rawJpegImageData) {
        this.jpegImageData = rawJpegImageData;
    }

    public JpegImageData getRawJpegImageData() {
        return this.jpegImageData;
    }

    public void setTiffImageData(TiffImageData rawTiffImageData) {
        this.tiffImageData = rawTiffImageData;
    }

    public TiffImageData getRawTiffImageData() {
        return this.tiffImageData;
    }

    public int getItemLength() {
        return 12 * this.fields.size() + 2 + 4;
    }

    public String getItemDescription() {
        TiffDirectoryConstants.ExifDirectoryType dirType = TagConstantsUtils.getExifDirectoryType(this.type);
        return "Directory: " + dirType.name + " (" + this.type + ")";
    }

    private void removeFieldIfPresent(TagInfo tagInfo) {
        TiffOutputField field = this.findField(tagInfo);
        if (null != field) {
            this.fields.remove(field);
        }
    }

    protected List getOutputItems(TiffOutputSummary outputSummary) throws ImageWriteException {
        int i;
        this.removeFieldIfPresent(TIFF_TAG_JPEG_INTERCHANGE_FORMAT);
        this.removeFieldIfPresent(TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
        TiffOutputField jpegOffsetField = null;
        if (null != this.jpegImageData) {
            jpegOffsetField = new TiffOutputField(TIFF_TAG_JPEG_INTERCHANGE_FORMAT, FIELD_TYPE_LONG, 1, FieldType.getStubLocalValue());
            this.add(jpegOffsetField);
            byte[] lengthValue = FIELD_TYPE_LONG.writeData(new int[]{this.jpegImageData.length}, outputSummary.byteOrder);
            TiffOutputField jpegLengthField = new TiffOutputField(TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, FIELD_TYPE_LONG, 1, lengthValue);
            this.add(jpegLengthField);
        }
        this.removeFieldIfPresent(TIFF_TAG_STRIP_OFFSETS);
        this.removeFieldIfPresent(TIFF_TAG_STRIP_BYTE_COUNTS);
        this.removeFieldIfPresent(TIFF_TAG_TILE_OFFSETS);
        this.removeFieldIfPresent(TIFF_TAG_TILE_BYTE_COUNTS);
        ImageDataOffsets imageDataInfo = null;
        if (null != this.tiffImageData) {
            TagInfo byteCountsTag;
            TagInfo offsetTag;
            boolean stripsNotTiles = this.tiffImageData.stripsNotTiles();
            if (stripsNotTiles) {
                offsetTag = TIFF_TAG_STRIP_OFFSETS;
                byteCountsTag = TIFF_TAG_STRIP_BYTE_COUNTS;
            } else {
                offsetTag = TIFF_TAG_TILE_OFFSETS;
                byteCountsTag = TIFF_TAG_TILE_BYTE_COUNTS;
            }
            TiffElement.DataElement[] imageData = this.tiffImageData.getImageData();
            int[] imageDataOffsets = null;
            int[] imageDataByteCounts = null;
            imageDataOffsets = new int[imageData.length];
            imageDataByteCounts = new int[imageData.length];
            for (int i2 = 0; i2 < imageData.length; ++i2) {
                imageDataByteCounts[i2] = imageData[i2].length;
            }
            TiffOutputField imageDataOffsetField = new TiffOutputField(offsetTag, FIELD_TYPE_LONG, imageDataOffsets.length, FIELD_TYPE_LONG.writeData(imageDataOffsets, outputSummary.byteOrder));
            this.add(imageDataOffsetField);
            byte[] data = FIELD_TYPE_LONG.writeData(imageDataByteCounts, outputSummary.byteOrder);
            TiffOutputField byteCountsField = new TiffOutputField(byteCountsTag, FIELD_TYPE_LONG, imageDataByteCounts.length, data);
            this.add(byteCountsField);
            imageDataInfo = new ImageDataOffsets(imageData, imageDataOffsets, imageDataOffsetField);
        }
        ArrayList<TiffOutputItem> result = new ArrayList<TiffOutputItem>();
        result.add(this);
        this.sortFields();
        for (i = 0; i < this.fields.size(); ++i) {
            TiffOutputField field = (TiffOutputField)this.fields.get(i);
            if (field.isLocalValue()) continue;
            TiffOutputItem item = field.getSeperateValue();
            result.add(item);
        }
        if (null != imageDataInfo) {
            for (i = 0; i < imageDataInfo.outputItems.length; ++i) {
                result.add(imageDataInfo.outputItems[i]);
            }
            outputSummary.addTiffImageData(imageDataInfo);
        }
        if (null != this.jpegImageData) {
            TiffOutputItem.Value item = new TiffOutputItem.Value("JPEG image data", this.jpegImageData.data);
            result.add(item);
            outputSummary.add(item, jpegOffsetField);
        }
        return result;
    }
}

