/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.ChainedBeanCreator;
import org.apache.commons.betwixt.io.read.ChainedBeanCreatorFactory;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;

public class BeanCreationList
extends BeanCreationChain {
    private ArrayList beanCreators = new ArrayList();

    public static final BeanCreationList createStandardChain() {
        BeanCreationList chain = new BeanCreationList();
        chain.addBeanCreator(ChainedBeanCreatorFactory.createIDREFBeanCreator());
        chain.addBeanCreator(ChainedBeanCreatorFactory.createDerivedBeanCreator());
        chain.addBeanCreator(ChainedBeanCreatorFactory.createElementTypeBeanCreator());
        return chain;
    }

    public Object create(ElementMapping elementMapping, ReadContext readContext) {
        ChainWorker worker = new ChainWorker();
        return worker.create(elementMapping, readContext);
    }

    public int getSize() {
        return this.beanCreators.size();
    }

    public void insertBeanCreator(int index, ChainedBeanCreator beanCreator) throws IndexOutOfBoundsException {
        this.beanCreators.add(index, beanCreator);
    }

    public void addBeanCreator(ChainedBeanCreator beanCreator) {
        this.beanCreators.add(beanCreator);
    }

    public void clearBeanCreators() {
        this.beanCreators.clear();
    }

    private class ChainWorker
    extends BeanCreationChain {
        private Iterator iterator;

        ChainWorker() {
            this.iterator = BeanCreationList.this.beanCreators.iterator();
        }

        public Object create(ElementMapping elementMapping, ReadContext readContext) {
            if (this.iterator.hasNext()) {
                ChainedBeanCreator beanCreator = (ChainedBeanCreator)this.iterator.next();
                return beanCreator.create(elementMapping, readContext, this);
            }
            return null;
        }
    }
}

