/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebDocumentException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;

public class WebException
extends WebApplicationException {
    private static final long serialVersionUID = 176876876786L;
    protected String message;
    protected boolean byPassAppResponse = false;
    protected int status = 500;

    public WebException() {
    }

    public WebException(Response response) {
        super(response);
    }

    public WebException(int status) {
        super(status);
        this.status = status;
    }

    public WebException(Response.Status status) {
        super(status);
        this.status = status.getStatusCode();
    }

    protected WebException(Throwable cause, Response response) {
        super(cause, response);
        this.byPassAppResponse = true;
    }

    protected WebException(Throwable cause, Response.Status status) {
        super(cause, status);
        this.status = status.getStatusCode();
    }

    protected WebException(Throwable cause, int status) {
        super(cause, status);
        this.status = status;
    }

    protected WebException(Throwable cause) {
        super(cause);
    }

    public WebException(String message) {
        this.message = message;
    }

    public WebException(String message, int code) {
        super(code);
        this.message = message;
        this.status = code;
    }

    protected WebException(String message, Throwable t) {
        super(t);
        this.message = message;
    }

    protected WebException(String message, Throwable t, int code) {
        super(t, code);
        this.message = message;
        this.status = code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatusCode() {
        return this.status;
    }

    @Deprecated
    public int getReturnCode() {
        return super.getResponse().getStatus();
    }

    public Response getResponse() {
        Object e;
        WebContext ctx;
        Response response = super.getResponse();
        if (!this.byPassAppResponse && (ctx = WebEngine.getActiveContext()) != null && ctx.head() instanceof ModuleResource) {
            ModuleResource mr = (ModuleResource)ctx.head();
            Object result = mr.handleError(this);
            if (result instanceof Response) {
                response = (Response)result;
            } else if (result != null) {
                response = Response.fromResponse((Response)response).entity(result).build();
            }
            return response;
        }
        for (e = this; ((Throwable)e).getMessage() == null && ((Throwable)e).getCause() != null && ((Throwable)e).getCause() != e; e = ((Throwable)e).getCause()) {
        }
        return Response.status((int)this.status).type("text/plain").entity((Object)WebException.toString((Throwable)e)).build();
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static Response toResponse(Throwable t) {
        return Response.status((int)500).entity((Object)WebException.toString(t)).build();
    }

    public static WebException wrap(Throwable e) {
        return WebException.wrap(null, e);
    }

    public static WebException wrap(String message, Throwable e) {
        if (e instanceof DocumentSecurityException || "javax.ejb.EJBAccessException".equals(e.getClass().getName())) {
            return new WebSecurityException(message, e);
        }
        if (e instanceof WebException) {
            return (WebException)((Object)e);
        }
        if (e instanceof ClientException) {
            Throwable cause = e.getCause();
            boolean notFound = false;
            if (cause instanceof NoSuchDocumentException) {
                notFound = true;
            } else if (cause != null && cause.getMessage() != null && cause.getMessage().contains("org.nuxeo.ecm.core.model.NoSuchDocumentException")) {
                notFound = true;
            }
            if (notFound) {
                return new WebResourceNotFoundException(cause.getMessage(), e);
            }
            return new WebDocumentException(message, (ClientException)e);
        }
        return new WebException(message, e);
    }

    public static Object handleError(WebApplicationException e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return Response.status((int)500).entity((Object)sw.toString()).build();
    }
}

