/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepositories;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;

public class NuxeoCmisServiceFactory
extends AbstractServiceFactory {
    public static final BigInteger DEFAULT_TYPES_MAX_ITEMS = BigInteger.valueOf(100L);
    public static final BigInteger DEFAULT_TYPES_DEPTH = BigInteger.valueOf(-1L);
    public static final BigInteger DEFAULT_MAX_ITEMS = BigInteger.valueOf(100L);
    public static final BigInteger DEFAULT_DEPTH = BigInteger.valueOf(2L);
    protected Map<String, NuxeoRepository> repositories;

    public void init(Map<String, String> parameters) {
        this.repositories = Collections.synchronizedMap(new HashMap());
    }

    public void destroy() {
        this.repositories = null;
    }

    public CmisService getService(CallContext context) {
        NuxeoRepository repository;
        String repositoryId = context.getRepositoryId();
        if (StringUtils.isEmpty((String)repositoryId)) {
            repository = null;
        } else {
            repository = NuxeoRepositories.getRepository((String)repositoryId);
            if (repository == null) {
                throw new CmisInvalidArgumentException("No such repository: " + repositoryId);
            }
        }
        NuxeoCmisService service = new NuxeoCmisService(repository, context);
        if (repository != null && service.getCoreSession() == null) {
            throw new CmisInvalidArgumentException("No such repository: " + repositoryId);
        }
        return new CmisServiceWrapper((CmisService)service, DEFAULT_TYPES_MAX_ITEMS, DEFAULT_TYPES_DEPTH, DEFAULT_MAX_ITEMS, DEFAULT_DEPTH);
    }
}

