/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import java.io.IOException;
import java.math.BigDecimal;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UIChart;
import org.jboss.seam.pdf.ui.UIChartSeries;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;

public class UIChartData
extends ITextComponent {
    private String key;
    private String series;
    private Object value;
    private Float explodedPercent;
    private String sectionPaint;
    private String sectionOutlinePaint;
    private String sectionOutlineStroke;

    public Object getValue() {
        return this.valueBinding("value", this.value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Number getNumericValue() {
        Object val = this.getValue();
        if (val instanceof Number) {
            return (Number)this.getValue();
        }
        if (val instanceof String) {
            return new BigDecimal((String)val);
        }
        throw new RuntimeException("Can't convert " + val.getClass().getName() + " to numeric value");
    }

    public String getKey() {
        return (String)this.valueBinding("key", this.key);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSeries() {
        String value = (String)this.valueBinding("series", this.series);
        if (value == null) {
            UIChartSeries series = (UIChartSeries)this.findITextParent((UIComponent)this, UIChartSeries.class);
            value = series.getKey();
        }
        return value;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Float getExplodedPercent() {
        return (Float)this.valueBinding("explodedPercent", this.explodedPercent);
    }

    public void setExplodedPercent(Float explodedPercent) {
        this.explodedPercent = explodedPercent;
    }

    public String getSectionOutlinePaint() {
        return (String)this.valueBinding("sectionOutlinePaint", this.sectionOutlinePaint);
    }

    public void setSectionOutlinePaint(String sectionOutlinePaint) {
        this.sectionOutlinePaint = sectionOutlinePaint;
    }

    public String getSectionOutlineStroke() {
        return (String)this.valueBinding("sectionOutlineStroke", this.sectionOutlineStroke);
    }

    public void setSectionOutlineStroke(String sectionOutlineStroke) {
        this.sectionOutlineStroke = sectionOutlineStroke;
    }

    public String getSectionPaint() {
        return (String)this.valueBinding("sectionPaint", this.sectionPaint);
    }

    public void setSectionPaint(String sectionPaint) {
        this.sectionPaint = sectionPaint;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.key = (String)values[1];
        this.series = (String)values[3];
        this.value = values[4];
        this.explodedPercent = (Float)values[5];
        this.sectionPaint = (String)values[6];
        this.sectionOutlinePaint = (String)values[7];
        this.sectionOutlineStroke = (String)values[8];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[9];
        values[0] = super.saveState(context);
        values[1] = this.key;
        values[3] = this.series;
        values[4] = this.value;
        values[5] = this.explodedPercent;
        values[6] = this.sectionPaint;
        values[7] = this.sectionOutlinePaint;
        values[8] = this.sectionOutlineStroke;
        return values;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        UIChart chart = (UIChart)this.findITextParent(this.getParent(), UIChart.class);
        if (chart != null) {
            Dataset dataset = chart.getDataset();
            if (dataset instanceof DefaultPieDataset) {
                DefaultPieDataset piedata = (DefaultPieDataset)dataset;
                piedata.setValue((Comparable)((Object)this.getKey()), this.getNumericValue());
                PiePlot plot = (PiePlot)chart.getChart().getPlot();
                if (this.getExplodedPercent() != null) {
                    plot.setExplodePercent((Comparable)((Object)this.getKey()), (double)this.getExplodedPercent().floatValue());
                }
                if (UIChart.findColor(this.getSectionPaint()) != null) {
                    plot.setSectionPaint((Comparable)((Object)this.getKey()), UIChart.findColor(this.getSectionPaint()));
                }
                if (UIChart.findColor(this.getSectionOutlinePaint()) != null) {
                    plot.setSectionOutlinePaint((Comparable)((Object)this.getKey()), UIChart.findColor(this.getSectionOutlinePaint()));
                }
                if (UIChart.findStroke(this.getSectionOutlineStroke()) != null) {
                    plot.setSectionOutlineStroke((Comparable)((Object)this.getKey()), UIChart.findStroke(this.getSectionOutlineStroke()));
                }
            } else if (dataset instanceof DefaultCategoryDataset) {
                DefaultCategoryDataset data = (DefaultCategoryDataset)dataset;
                data.addValue(this.getNumericValue(), (Comparable)((Object)this.getSeries()), (Comparable)((Object)this.getKey()));
            } else {
                throw new RuntimeException("Cannot add data to dataset of type " + dataset.getClass());
            }
        }
    }

    public void createITextObject(FacesContext context) {
    }

    public Object getITextObject() {
        return null;
    }

    public void handleAdd(Object other) {
    }

    public void removeITextObject() {
    }
}

