/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
extends AbstractWebServicesService
implements RepositoryService {
    private final AbstractPortProvider portProvider;

    public RepositoryServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        CmisVersion cmisVersion = CmisBindingsHelper.getForcedCmisVersion(this.getSession());
        if (cmisVersion == null) {
            cmisVersion = CmisVersion.CMIS_1_1;
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(cmisVersion, "getRepositories");
        List entries = null;
        try {
            entries = port.getRepositories(WSConverter.convert((ExtensionsData)extension));
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
        ArrayList<RepositoryInfo> infos = null;
        if (entries != null) {
            port = this.portProvider.getRepositoryServicePort(cmisVersion, "getRepositoryInfo");
            try {
                infos = new ArrayList<RepositoryInfo>();
                for (CmisRepositoryEntryType entry : entries) {
                    CmisRepositoryInfoType info = port.getRepositoryInfo(entry.getRepositoryId(), null);
                    infos.add(WSConverter.convert((CmisRepositoryInfoType)info));
                }
            }
            catch (CmisException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.portProvider.endCall(port);
            }
        }
        return infos;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        CmisVersion cmisVersion = CmisBindingsHelper.getForcedCmisVersion(this.getSession());
        if (cmisVersion == null) {
            cmisVersion = CmisVersion.CMIS_1_1;
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(cmisVersion, "getRepositoryInfo");
        try {
            RepositoryInfo repositoryInfo = WSConverter.convert((CmisRepositoryInfoType)port.getRepositoryInfo(repositoryId, WSConverter.convert((ExtensionsData)extension)));
            return repositoryInfo;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(this.getCmisVersion(repositoryId), "getTypeDefinition");
        try {
            TypeDefinition typeDefinition = WSConverter.convert((CmisTypeDefinitionType)port.getTypeDefinition(repositoryId, typeId, WSConverter.convert((ExtensionsData)extension)));
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(this.getCmisVersion(repositoryId), "getTypeChildren");
        try {
            TypeDefinitionList typeDefinitionList = WSConverter.convert((CmisTypeDefinitionListType)port.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, WSConverter.convert((ExtensionsData)extension)));
            return typeDefinitionList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(this.getCmisVersion(repositoryId), "getTypeDescendants");
        try {
            List list = WSConverter.convertTypeContainerList((List)port.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, WSConverter.convert((ExtensionsData)extension)));
            return list;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(CmisVersion.CMIS_1_1, "createType");
        try {
            Holder typeDef = new Holder((Object)WSConverter.convert((TypeDefinition)type));
            port.createType(repositoryId, typeDef, WSConverter.convert((ExtensionsData)extension));
            TypeDefinition typeDefinition = WSConverter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)typeDef.value));
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(CmisVersion.CMIS_1_1, "updateType");
        try {
            Holder typeDef = new Holder((Object)WSConverter.convert((TypeDefinition)type));
            port.updateType(repositoryId, typeDef, WSConverter.convert((ExtensionsData)extension));
            TypeDefinition typeDefinition = WSConverter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)typeDef.value));
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(CmisVersion.CMIS_1_1, "deleteType");
        try {
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.deleteType(repositoryId, typeId, portExtension);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

