/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Hashtable;

public class URLStreamHandlerFactoryInstaller {
    private static final FactoryStack factoryStack = new FactoryStack();

    private URLStreamHandlerFactoryInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installURLStreamHandlerFactory(URLStreamHandlerFactory shf) {
        Object lock;
        Field factoryField = URLStreamHandlerFactoryInstaller.getStaticField(URL.class, URLStreamHandlerFactory.class);
        if (factoryField == null) {
            throw new IllegalArgumentException("Could not find URLStreamHandlerFactory field");
        }
        Object object = lock = URLStreamHandlerFactoryInstaller.getURLStreamHandlerFactoryLock();
        synchronized (object) {
            try {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory == null) {
                    factoryStack.push(shf);
                } else if (factory != factoryStack) {
                    factoryStack.push(factory);
                    factoryStack.push(shf);
                } else {
                    factoryStack.push(shf);
                }
                factoryField.set(null, null);
                URLStreamHandlerFactoryInstaller.resetURLStreamHandlers();
                URL.setURLStreamHandlerFactory(factoryStack);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static void uninstallURLStreamHandlerFactory() {
        try {
            Field factoryField = URLStreamHandlerFactoryInstaller.getStaticField(URL.class, URLStreamHandlerFactory.class);
            if (factoryField == null) {
                return;
            }
            factoryField.set(null, null);
            URLStreamHandlerFactoryInstaller.resetURLStreamHandlers();
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstallURLStreamHandlerFactory(URLStreamHandlerFactory shf) {
        try {
            Object lock;
            Field factoryField = URLStreamHandlerFactoryInstaller.getStaticField(URL.class, URLStreamHandlerFactory.class);
            if (factoryField == null) {
                return;
            }
            Object object = lock = URLStreamHandlerFactoryInstaller.getURLStreamHandlerFactoryLock();
            synchronized (object) {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory == null) {
                    return;
                }
                if (factory != factoryStack) {
                    return;
                }
                if (shf == null) {
                    factoryStack.pop();
                } else {
                    factoryStack.remove(shf);
                }
                factoryField.set(null, null);
                URLStreamHandlerFactoryInstaller.resetURLStreamHandlers();
                URL.setURLStreamHandlerFactory(factoryStack);
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static Field getStaticField(Class<?> clazz, Class<?> type) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(type)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public static void resetURLStreamHandlers() {
        Field handlersField = URLStreamHandlerFactoryInstaller.getStaticField(URL.class, Hashtable.class);
        if (handlersField != null) {
            Hashtable handlers;
            try {
                handlers = (Hashtable)handlersField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot clear URL handlers cache", e);
            }
            if (handlers != null) {
                handlers.clear();
            }
        }
    }

    private static Object getURLStreamHandlerFactoryLock() {
        Object lock;
        try {
            Field streamHandlerLockField = URL.class.getDeclaredField("streamHandlerLock");
            streamHandlerLockField.setAccessible(true);
            lock = streamHandlerLockField.get(null);
        }
        catch (NoSuchFieldException noField) {
            lock = URL.class;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        return lock;
    }

    public static FactoryStack getStack() {
        return factoryStack;
    }

    public static class FactoryStack
    implements URLStreamHandlerFactory {
        final ArrayList<URLStreamHandlerFactory> factories = new ArrayList();

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            for (int i = this.factories.size() - 1; i >= 0; --i) {
                URLStreamHandler h = this.factories.get(i).createURLStreamHandler(protocol);
                if (h == null) continue;
                return h;
            }
            return null;
        }

        public void push(URLStreamHandlerFactory factory) {
            this.factories.add(factory);
        }

        public URLStreamHandlerFactory pop() {
            if (this.factories.isEmpty()) {
                return null;
            }
            return this.factories.remove(this.factories.size() - 1);
        }

        URLStreamHandlerFactory remove(URLStreamHandlerFactory shf) {
            return this.factories.remove(this.factories.indexOf(shf));
        }

        public URLStreamHandlerFactory peek() {
            if (this.factories.isEmpty()) {
                return null;
            }
            return this.factories.get(this.factories.size() - 1);
        }

        public boolean isEmpty() {
            return this.factories.isEmpty();
        }

        public int size() {
            return this.factories.size();
        }

        public void clear() {
            this.factories.clear();
        }
    }
}

