/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;

@XObject(value="repository")
public class RepositoryDescriptor {
    private static final Log log = LogFactory.getLog(RepositoryDescriptor.class);
    @XNode(value="@name")
    public String name;
    @XNode(value="listen")
    public ServerDescriptor listen;
    @XNodeList(value="connect", type=ArrayList.class, componentType=ServerDescriptor.class)
    public List<ServerDescriptor> connect = Collections.emptyList();
    @XNode(value="backendClass")
    public Class<? extends RepositoryBackend> backendClass;
    @XNode(value="cachingMapper@class")
    public Class<? extends CachingMapper> cachingMapperClass;
    @XNode(value="cachingMapper@enabled")
    public boolean cachingMapperEnabled = true;
    @XNodeMap(value="cachingMapper/property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> cachingMapperProperties = new HashMap<String, String>();
    @XNode(value="noDDL")
    public boolean noDDL = false;
    @XNodeList(value="sqlInitFile", type=ArrayList.class, componentType=String.class)
    public List<String> sqlInitFiles;
    @XNode(value="softDelete@enabled")
    public boolean softDeleteEnabled;
    @XNode(value="proxies@enabled")
    public boolean proxiesEnabled = true;
    @XNode(value="idType")
    public String idType;
    @XNode(value="clustering@enabled")
    public boolean clusteringEnabled;
    @XNode(value="clustering@delay")
    public long clusteringDelay;
    @XNodeList(value="schema/field", type=ArrayList.class, componentType=FieldDescriptor.class)
    public List<FieldDescriptor> schemaFields = Collections.emptyList();
    @XNode(value="schema/arrayColumns")
    public boolean arrayColumns;
    @XNode(value="indexing/fulltext@disabled")
    public boolean fulltextDisabled;
    @XNode(value="indexing/fulltext@analyzer")
    public String fulltextAnalyzer;
    @XNode(value="indexing/fulltext@parser")
    public String fulltextParser;
    @XNode(value="indexing/fulltext@catalog")
    public String fulltextCatalog;
    @XNodeList(value="indexing/fulltext/index", type=ArrayList.class, componentType=FulltextIndexDescriptor.class)
    public List<FulltextIndexDescriptor> fulltextIndexes;
    @XNodeList(value="indexing/excludedTypes/type", type=HashSet.class, componentType=String.class)
    public Set<String> fulltextExcludedTypes;
    @XNodeList(value="indexing/includedTypes/type", type=HashSet.class, componentType=String.class)
    public Set<String> fulltextIncludedTypes;
    @XNodeList(value="indexing/neverPerDocumentFacets/facet", type=HashSet.class, componentType=String.class)
    public Set<String> neverPerInstanceMixins;
    @XNode(value="pathOptimizations@enabled")
    public boolean pathOptimizationsEnabled = true;
    @XNode(value="pathOptimizations@version")
    public int pathOptimizationsVersion = 2;
    @XNode(value="aclOptimizations@enabled")
    public boolean aclOptimizationsEnabled = true;
    @XNode(value="aclOptimizations@concurrentUpdate")
    public boolean aclOptimizationsConcurrentUpdate = true;
    @XNode(value="aclOptimizations@readAclMaxSize")
    public int readAclMaxSize = 4096;
    @XNode(value="binaryManager@class")
    public Class<? extends BinaryManager> binaryManagerClass;
    @XNode(value="binaryManager@key")
    public String binaryManagerKey;
    @XNode(value="binaryManager@listen")
    public boolean binaryManagerListen;
    @XNode(value="binaryManager@connect")
    public boolean binaryManagerConnect;
    @XNode(value="binaryStore@path")
    public String binaryStorePath;
    @XNode(value="@sendInvalidationEvents")
    public boolean sendInvalidationEvents;
    @XNode(value="xa-datasource")
    public String xaDataSourceName;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties;
    @XNode(value="usersSeparator@key")
    public String usersSeparatorKey;

    @XNode(value="indexing/queryMaker@class")
    public void setQueryMakerDeprecated(String klass) {
        log.warn((Object)"Setting queryMaker from repository configuration is now deprecated");
    }

    public void mergeFrom(RepositoryDescriptor other) {
        this.listen = other.listen;
        this.connect = other.connect;
        this.backendClass = other.backendClass;
        this.cachingMapperClass = other.cachingMapperClass;
        this.cachingMapperEnabled = other.cachingMapperEnabled;
        this.clusteringEnabled = other.clusteringEnabled;
        this.clusteringDelay = other.clusteringDelay;
        this.noDDL = other.noDDL;
        this.sqlInitFiles = other.sqlInitFiles;
        this.softDeleteEnabled = other.softDeleteEnabled;
        this.proxiesEnabled = other.proxiesEnabled;
        this.schemaFields = other.schemaFields;
        this.arrayColumns = other.arrayColumns;
        this.fulltextDisabled = other.fulltextDisabled;
        this.fulltextAnalyzer = other.fulltextAnalyzer;
        this.fulltextCatalog = other.fulltextCatalog;
        this.fulltextIndexes = other.fulltextIndexes;
        this.neverPerInstanceMixins = other.neverPerInstanceMixins;
        this.pathOptimizationsEnabled = other.pathOptimizationsEnabled;
        this.pathOptimizationsVersion = other.pathOptimizationsVersion;
        this.aclOptimizationsEnabled = other.aclOptimizationsEnabled;
        this.aclOptimizationsConcurrentUpdate = other.aclOptimizationsConcurrentUpdate;
        this.readAclMaxSize = other.readAclMaxSize;
        this.binaryStorePath = other.binaryStorePath;
        this.binaryManagerClass = other.binaryManagerClass;
        this.binaryManagerKey = other.binaryManagerKey;
        this.binaryManagerListen = other.binaryManagerListen;
        this.binaryManagerConnect = other.binaryManagerConnect;
        this.sendInvalidationEvents = other.sendInvalidationEvents;
        this.usersSeparatorKey = other.usersSeparatorKey;
    }

    @XObject(value="server")
    public static class ServerDescriptor {
        @XNode(value="@disabled")
        public boolean disabled;
        @XNode(value="host")
        public String host = "localhost";
        @XNode(value="port")
        public int port = 8181;
        @XNode(value="path")
        public String path = "/nuxeo";

        public String getUrl() {
            return "http://" + this.host + ":" + this.port + (this.path.startsWith("/") ? "" : "/") + this.path;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.getUrl() + ')';
        }
    }

    @XObject(value="field")
    public static class FieldDescriptor {
        @XNode(value="@type")
        public String type;
        @XNode(value="@name")
        public String field;
        @XNode(value="@table")
        public String table;
        @XNode(value="@column")
        public String column;

        public void setName(String name) {
            if (!StringUtils.isBlank((String)name) && this.field == null) {
                this.field = name;
            }
        }

        @XNode
        public void setXNodeContent(String name) {
            this.setName(name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.field + ",type=" + this.type + ",table=" + this.table + ",column=" + this.column + ")";
        }
    }

    @XObject(value="index")
    public static class FulltextIndexDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@analyzer")
        public String analyzer;
        @XNode(value="@catalog")
        public String catalog;
        @XNode(value="fieldType")
        public String fieldType;
        @XNodeList(value="field", type=HashSet.class, componentType=String.class)
        public Set<String> fields;
        @XNodeList(value="excludeField", type=HashSet.class, componentType=String.class)
        public Set<String> excludeFields;
    }
}

