/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.net.MapperClient;

public class NetBackend
implements RepositoryBackend {
    private static final Log log = LogFactory.getLog(NetBackend.class);
    protected RepositoryImpl repository;

    @Override
    public void initialize(RepositoryImpl repository) throws StorageException {
        this.repository = repository;
    }

    @Override
    public void initializeModelSetup(ModelSetup modelSetup) throws StorageException {
        modelSetup.materializeFulltextSyntheticColumn = false;
    }

    @Override
    public void initializeModel(Model model) throws StorageException {
    }

    @Override
    public Mapper newMapper(Model model, Session.PathResolver pathResolver, RepositoryBackend.MapperKind kind) throws StorageException {
        try {
            return MapperClient.getMapper(this.repository, null);
        }
        catch (StorageException e) {
            String url = MapperClient.getUrl(this.repository.getRepositoryDescriptor());
            log.error((Object)("Failed to connect to server: " + url), (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public void shutdown() {
    }
}

