/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.h2.api.CloseListener;
import org.h2.message.Message;
import org.h2.store.fs.FileSystem;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class H2Fulltext {
    private static final Map<String, IndexWriter> indexWriters = new ConcurrentHashMap<String, IndexWriter>();
    private static final String FT_SCHEMA = "NXFT";
    private static final String FT_TABLE = "NXFT.INDEXES";
    private static final String PREFIX = "NXFT_";
    private static final String FIELD_KEY = "KEY";
    private static final String FIELD_TEXT = "TEXT";
    private static final String DEFAULT_INDEX_NAME = "PUBLIC_FULLTEXT_default";
    private static final String COL_KEY = "KEY";

    private H2Fulltext() {
    }

    public static void init(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        st.execute("CREATE SCHEMA IF NOT EXISTS NXFT");
        st.execute("CREATE TABLE IF NOT EXISTS NXFT.INDEXES(NAME VARCHAR, SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, ANALYZER VARCHAR, PRIMARY KEY(NAME))");
        ResultSet rs = st.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'NXFT' AND TABLE_NAME = 'INDEXES' AND COLUMN_NAME = 'NAME'");
        if (!rs.next()) {
            st.execute("ALTER TABLE NXFT.INDEXES ADD COLUMN NAME VARCHAR");
            st.execute("UPDATE NXFT.INDEXES SET NAME = 'PUBLIC_FULLTEXT_default'");
        }
        String className = H2Fulltext.class.getName();
        st.execute("CREATE ALIAS IF NOT EXISTS NXFT_CREATE_INDEX FOR \"" + className + ".createIndex\"");
        st.execute("CREATE ALIAS IF NOT EXISTS NXFT_REINDEX FOR \"" + className + ".reindex\"");
        st.execute("CREATE ALIAS IF NOT EXISTS NXFT_DROP_ALL FOR \"" + className + ".dropAll\"");
        st.execute("CREATE ALIAS IF NOT EXISTS NXFT_SEARCH FOR \"" + className + ".search\"");
    }

    public static void createIndex(Connection conn, String indexName, String schema, String table, String columns, String analyzer) throws SQLException {
        if (indexName == null) {
            indexName = DEFAULT_INDEX_NAME;
        }
        columns = columns.replace("(", "").replace(")", "").replace(" ", "");
        PreparedStatement ps = conn.prepareStatement("DELETE FROM NXFT.INDEXES WHERE NAME = ?");
        ps.setString(1, indexName);
        ps.execute();
        ps = conn.prepareStatement("INSERT INTO NXFT.INDEXES(NAME, SCHEMA, TABLE, COLUMNS, ANALYZER) VALUES(?, ?, ?, ?, ?)");
        ps.setString(1, indexName);
        ps.setString(2, schema);
        ps.setString(3, table);
        ps.setString(4, columns);
        ps.setString(5, analyzer);
        ps.execute();
        ps.close();
        H2Fulltext.createTrigger(conn, schema, table);
    }

    public static void reindex(Connection conn) throws SQLException {
        H2Fulltext.removeAllTriggers(conn);
        H2Fulltext.removeIndexFiles(conn);
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM NXFT.INDEXES");
        HashSet<String> done = new HashSet<String>();
        while (rs.next()) {
            String schema = rs.getString("SCHEMA");
            String table = rs.getString("TABLE");
            String key = schema + '.' + table;
            if (!done.add(key)) continue;
            H2Fulltext.createTrigger(conn, schema, table);
            H2Fulltext.indexExistingRows(conn, schema, table);
        }
        st.close();
    }

    private static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        Trigger trigger = new Trigger();
        trigger.init(conn, schema, null, table, false, 1);
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM " + StringUtils.quoteIdentifier((String)schema) + '.' + StringUtils.quoteIdentifier((String)table));
        int n = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[n];
            for (int i = 0; i < n; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            trigger.fire(conn, null, row);
        }
        st.close();
    }

    private static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        Statement st = conn.createStatement();
        schema = StringUtils.quoteIdentifier((String)schema);
        String trigger = schema + '.' + StringUtils.quoteIdentifier((String)(PREFIX + table));
        st.execute("DROP TRIGGER IF EXISTS " + trigger);
        st.execute(String.format("CREATE TRIGGER %s AFTER INSERT, UPDATE, DELETE ON %s.%s FOR EACH ROW CALL \"%s\"", trigger, schema, StringUtils.quoteIdentifier((String)table), Trigger.class.getName()));
        st.close();
    }

    private static void removeAllTriggers(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement st2 = conn.createStatement();
        while (rs.next()) {
            String trigger = rs.getString("TRIGGER_NAME");
            if (!trigger.startsWith(PREFIX)) continue;
            st2.execute("DROP TRIGGER " + StringUtils.quoteIdentifier((String)rs.getString("TRIGGER_SCHEMA")) + "." + trigger);
        }
        st.close();
        st2.close();
    }

    public static void dropAll(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        st.execute("DROP SCHEMA IF EXISTS NXFT");
        st.close();
        H2Fulltext.removeAllTriggers(conn);
        H2Fulltext.removeIndexFiles(conn);
    }

    private static String fieldForIndex(String indexName) {
        if (DEFAULT_INDEX_NAME.equals(indexName)) {
            return FIELD_TEXT;
        }
        return "TEXT_" + indexName;
    }

    public static ResultSet search(Connection conn, String indexName, String text) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        if (indexName == null) {
            indexName = DEFAULT_INDEX_NAME;
        }
        PreparedStatement ps = conn.prepareStatement("SELECT SCHEMA, TABLE, ANALYZER FROM NXFT.INDEXES WHERE NAME = ?");
        ps.setString(1, indexName);
        ResultSet res = ps.executeQuery();
        if (!res.next()) {
            throw new SQLException("No such index: " + indexName);
        }
        String schema = res.getString(1);
        String table = res.getString(2);
        String analyzer = res.getString(3);
        ps.close();
        int type = H2Fulltext.getPrimaryKeyType(meta, schema, table);
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("KEY", type, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return rs;
        }
        String indexPath = H2Fulltext.getIndexPath(conn);
        try {
            BooleanQuery query = new BooleanQuery();
            QueryParser parser = new QueryParser(H2Fulltext.fieldForIndex(indexName), H2Fulltext.getAnalyzer(analyzer));
            query.add(parser.parse(text), BooleanClause.Occur.MUST);
            H2Fulltext.getIndexWriter(indexPath, analyzer).flush();
            IndexSearcher searcher = new IndexSearcher(indexPath);
            for (Hit hit : searcher.search((Query)query)) {
                Object key = H2Fulltext.asObject(hit.get("KEY"), type);
                rs.addRow(new Object[]{key});
            }
            searcher.close();
        }
        catch (Exception e) {
            throw H2Fulltext.convertException(e);
        }
        return rs;
    }

    private static int getPrimaryKeyType(DatabaseMetaData meta, String schema, String table) throws SQLException {
        String primaryKeyName = null;
        ResultSet rs = meta.getPrimaryKeys(null, schema, table);
        while (rs.next()) {
            if (primaryKeyName != null) {
                throw new SQLException("Can only index primary keys on one column for " + schema + '.' + table);
            }
            primaryKeyName = rs.getString("COLUMN_NAME");
        }
        if (primaryKeyName == null) {
            throw new SQLException("No primary key for " + schema + '.' + table);
        }
        rs.close();
        rs = meta.getColumns(null, schema, table, primaryKeyName);
        if (!rs.next()) {
            throw new SQLException("Could not find primary key");
        }
        int primaryKeyType = rs.getInt("DATA_TYPE");
        rs.close();
        return primaryKeyType;
    }

    private static Analyzer getAnalyzer(String analyzer) throws SQLException {
        try {
            return (Analyzer)Class.forName(analyzer).newInstance();
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    private static String getIndexPath(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("CALL DATABASE_PATH()");
        rs.next();
        String path = rs.getString(1);
        if (path == null) {
            throw new SQLException("Fulltext search for in-memory databases is not supported.");
        }
        st.close();
        return path + ".lucene";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexWriter getIndexWriter(String indexPath, String analyzer) throws SQLException {
        IndexWriter indexWriter = indexWriters.get(indexPath);
        if (indexWriter == null) {
            Map<String, IndexWriter> map = indexWriters;
            synchronized (map) {
                if (!indexWriters.containsKey(indexPath)) {
                    try {
                        boolean recreate = !IndexReader.indexExists((String)indexPath);
                        indexWriter = new IndexWriter(indexPath, H2Fulltext.getAnalyzer(analyzer), recreate);
                    }
                    catch (LockObtainFailedException e) {
                        System.err.println("Cannot open fulltext index " + indexPath);
                        e.printStackTrace();
                        throw H2Fulltext.convertException((Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw H2Fulltext.convertException(e);
                    }
                    indexWriters.put(indexPath, indexWriter);
                }
            }
        }
        return indexWriter;
    }

    private static void removeIndexFiles(Connection conn) throws SQLException {
        String path = H2Fulltext.getIndexPath(conn);
        IndexWriter index = indexWriters.remove(path);
        if (index != null) {
            try {
                index.flush();
                index.close();
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
        }
        FileSystem.getInstance((String)path).deleteRecursive(path);
    }

    private static SQLException convertException(Exception e) {
        SQLException e2 = new SQLException("Error while indexing document");
        e2.initCause(e);
        return e2;
    }

    protected static String asString(Object data, int type) throws SQLException {
        if (data == null) {
            return "";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return data.toString();
            }
            case 2005: {
                try {
                    if (data instanceof Clob) {
                        data = ((Clob)data).getCharacterStream();
                    }
                    return IOUtils.readStringAndClose((Reader)((Reader)data), (int)-1);
                }
                catch (IOException e) {
                    throw Message.convert((Throwable)e);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                throw new SQLException("Unsupported column data type: " + type);
            }
        }
        return "";
    }

    private static Object asObject(String string, int type) throws SQLException {
        switch (type) {
            case -5: {
                return Long.valueOf(string);
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.valueOf(string);
            }
            case -1: 
            case 1: 
            case 12: {
                return string;
            }
        }
        throw new SQLException("Unsupport data type for primary key: " + type);
    }

    public static class Trigger
    implements org.h2.api.Trigger,
    CloseListener {
        private static final Log log = LogFactory.getLog(Trigger.class);
        private String indexPath;
        private IndexWriter indexWriter;
        private Exception lastIndexWriterClose;
        private String lastIndexWriterCloseThread;
        private int primaryKeyIndex;
        private int primaryKeyType;
        private Map<String, int[]> columnTypes;
        private Map<String, int[]> columnIndices;

        public void init(Connection conn, String schema, String triggerName, String table, boolean before, int opType) throws SQLException {
            this.indexPath = H2Fulltext.getIndexPath(conn);
            DatabaseMetaData meta = conn.getMetaData();
            String primaryKeyName = null;
            ResultSet rs = meta.getPrimaryKeys(null, schema, table);
            while (rs.next()) {
                if (primaryKeyName != null) {
                    throw new SQLException("Can only index primary keys on one column for: " + schema + '.' + table);
                }
                primaryKeyName = rs.getString("COLUMN_NAME");
            }
            if (primaryKeyName == null) {
                throw new SQLException("No primary key for " + schema + '.' + table);
            }
            rs.close();
            rs = meta.getColumns(null, schema, table, primaryKeyName);
            if (!rs.next()) {
                throw new SQLException("No primary key for: " + schema + '.' + table);
            }
            this.primaryKeyType = rs.getInt("DATA_TYPE");
            this.primaryKeyIndex = rs.getInt("ORDINAL_POSITION") - 1;
            rs.close();
            HashMap<String, Integer> allColumnTypes = new HashMap<String, Integer>();
            HashMap<String, Integer> allColumnIndices = new HashMap<String, Integer>();
            rs = meta.getColumns(null, schema, table, null);
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                int type = rs.getInt("DATA_TYPE");
                int index = rs.getInt("ORDINAL_POSITION") - 1;
                allColumnTypes.put(name, type);
                allColumnIndices.put(name, index);
            }
            rs.close();
            PreparedStatement ps = conn.prepareStatement("SELECT NAME, COLUMNS, ANALYZER FROM NXFT.INDEXES WHERE SCHEMA = ? AND TABLE = ?");
            ps.setString(1, schema);
            ps.setString(2, table);
            rs = ps.executeQuery();
            this.columnTypes = new HashMap<String, int[]>();
            this.columnIndices = new HashMap<String, int[]>();
            while (rs.next()) {
                String indexName = rs.getString(1);
                String columns = rs.getString(2);
                String analyzer = rs.getString(3);
                List<String> columnNames = Arrays.asList(columns.split(","));
                int[] types = new int[columnNames.size()];
                int[] indices = new int[columnNames.size()];
                int i = 0;
                for (String columnName : columnNames) {
                    types[i] = (Integer)allColumnTypes.get(columnName);
                    indices[i] = (Integer)allColumnIndices.get(columnName);
                    ++i;
                }
                this.columnTypes.put(indexName, types);
                this.columnIndices.put(indexName, indices);
                this.indexWriter = H2Fulltext.getIndexWriter(this.indexPath, analyzer);
            }
            rs.close();
            ps.close();
        }

        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (this.indexWriter == null) {
                throw new SQLException("Fulltext index was not initialized");
            }
            if (oldRow != null) {
                this.delete(oldRow);
            }
            if (newRow != null) {
                this.insert(newRow);
            }
            try {
                this.indexWriter.flush();
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
        }

        private void insert(Object[] row) throws SQLException {
            Document doc = new Document();
            String key = H2Fulltext.asString(row[this.primaryKeyIndex], this.primaryKeyType);
            doc.add((Fieldable)new Field("KEY", key, Field.Store.YES, Field.Index.UN_TOKENIZED));
            for (String indexName : this.columnTypes.keySet()) {
                int[] types = this.columnTypes.get(indexName);
                int[] indices = this.columnIndices.get(indexName);
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < types.length; ++i) {
                    String data = H2Fulltext.asString(row[indices[i]], types[i]);
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(data);
                }
                doc.add((Fieldable)new Field(H2Fulltext.fieldForIndex(indexName), buf.toString(), Field.Store.NO, Field.Index.TOKENIZED));
            }
            try {
                this.indexWriter.addDocument(doc);
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
            catch (AlreadyClosedException e) {
                log.error((Object)("org.apache.lucene.store.AlreadyClosedException in thread " + Thread.currentThread().getName() + ", last close was in thread " + this.lastIndexWriterCloseThread), (Throwable)this.lastIndexWriterClose);
                throw e;
            }
        }

        private void delete(Object[] row) throws SQLException {
            String primaryKey = H2Fulltext.asString(row[this.primaryKeyIndex], this.primaryKeyType);
            try {
                this.indexWriter.deleteDocuments(new Term("KEY", primaryKey));
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
        }

        public void close() throws SQLException {
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.flush();
                    this.lastIndexWriterClose = new Exception("debug stack trace");
                    this.lastIndexWriterCloseThread = Thread.currentThread().getName();
                    this.indexWriter.close();
                    this.indexWriter = null;
                    indexWriters.remove(this.indexPath);
                }
                catch (Exception e) {
                    throw H2Fulltext.convertException(e);
                }
            }
        }

        public void remove() {
        }
    }
}

