/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;

public class LayoutRowWidgetTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutRowWidgetTagHandler.class);
    protected final TagConfig config;

    public LayoutRowWidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        LayoutRow row = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        String rowVariableName = RenderVariables.rowVariables.layoutRow.name();
        TagAttribute rowAttribute = helper.createAttribute(rowVariableName, String.format("#{%s}", rowVariableName));
        if (rowAttribute != null) {
            row = (LayoutRow)rowAttribute.getObject(ctx, LayoutRow.class);
        }
        if (row == null) {
            log.error((Object)("Could not resolve layout row " + rowAttribute));
            return;
        }
        Widget[] widgets = row.getWidgets();
        if (widgets == null || widgets.length == 0) {
            return;
        }
        int widgetCounter = 0;
        for (Widget widget : widgets) {
            WidgetTagHandler.generateWidgetIdsRecursive(helper, widget);
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression widgetVe = eFactory.createValueExpression((Object)widget, Widget.class);
            variables.put(RenderVariables.widgetVariables.widget.name(), widgetVe);
            Integer level = null;
            String tagConfigId = null;
            if (widget != null) {
                level = widget.getLevel();
                tagConfigId = widget.getTagConfigId();
            }
            variables.put(String.format("%s_%s", RenderVariables.widgetVariables.widget.name(), level), widgetVe);
            ValueExpression widgetIndexVe = eFactory.createValueExpression((Object)widgetCounter, Integer.class);
            variables.put(RenderVariables.widgetVariables.widgetIndex.name(), widgetIndexVe);
            variables.put(String.format("%s_%s", RenderVariables.widgetVariables.widgetIndex.name(), level), widgetIndexVe);
            if (widget != null) {
                for (Map.Entry ctrl : widget.getControls().entrySet()) {
                    String key = (String)ctrl.getKey();
                    String name = String.format("%s_%s", RenderVariables.widgetVariables.widgetControl.name(), key);
                    Serializable value = (Serializable)ctrl.getValue();
                    variables.put(name, eFactory.createValueExpression((Object)value, Object.class));
                }
            }
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.widget.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetIndex.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetControl.name() + "_*");
            FaceletHandler handler = helper.getAliasTagHandler(tagConfigId, variables, blockedPatterns, this.nextHandler);
            handler.apply(ctx, parent);
            ++widgetCounter;
        }
    }
}

