/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ECSSAttributeOperator;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorAttribute
implements ICSSSelectorMember {
    private final String m_sNamespacePrefix;
    private final String m_sAttrName;
    private final ECSSAttributeOperator m_eOperator;
    private final String m_sAttrValue;

    private static boolean _isValidNamespacePrefix(@Nullable String string) {
        return StringHelper.hasNoText((CharSequence)string) || string.endsWith("|");
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonnull @Nonempty String string2) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        if (StringHelper.hasNoText((CharSequence)string2)) {
            throw new IllegalArgumentException("attrName");
        }
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = null;
        this.m_sAttrValue = null;
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull ECSSAttributeOperator eCSSAttributeOperator, @Nonnull String string3) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        if (StringHelper.hasNoText((CharSequence)string2)) {
            throw new IllegalArgumentException("attrName");
        }
        if (eCSSAttributeOperator == null) {
            throw new NullPointerException("operator");
        }
        if (string3 == null) {
            throw new NullPointerException("attrValue");
        }
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = eCSSAttributeOperator;
        this.m_sAttrValue = string3;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonnull
    @Nonempty
    public String getAttrName() {
        return this.m_sAttrName;
    }

    @Nullable
    public ECSSAttributeOperator getOperator() {
        return this.m_eOperator;
    }

    @Nullable
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (StringHelper.hasText((CharSequence)this.m_sNamespacePrefix)) {
            stringBuilder.append(this.m_sNamespacePrefix);
        }
        stringBuilder.append(this.m_sAttrName);
        if (this.m_eOperator != null) {
            stringBuilder.append(this.m_eOperator.getAsCSSString(iCSSWriterSettings, n)).append(this.m_sAttrValue);
        }
        return stringBuilder.append(']').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSSelectorAttribute)) {
            return false;
        }
        CSSSelectorAttribute cSSSelectorAttribute = (CSSSelectorAttribute)object;
        return EqualsUtils.equals((Object)this.m_sNamespacePrefix, (Object)cSSSelectorAttribute.m_sNamespacePrefix) && this.m_sAttrName.equals(cSSSelectorAttribute.m_sAttrName) && EqualsUtils.equals((Object)this.m_eOperator, (Object)cSSSelectorAttribute.m_eOperator) && EqualsUtils.equals((Object)this.m_sAttrValue, (Object)cSSSelectorAttribute.m_sAttrValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sNamespacePrefix).append((Object)this.m_sAttrName).append((Enum)this.m_eOperator).append((Object)this.m_sAttrValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("namespacePrefix", (Object)this.m_sNamespacePrefix).append("attrName", (Object)this.m_sAttrName).appendIfNotNull("operator", (Object)this.m_eOperator).appendIfNotNull("attrValue", (Object)this.m_sAttrValue).toString();
    }
}

