/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.adapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class MailMessageBlobHolder
extends DocumentBlobHolder {
    protected Pattern isHtmlPattern = Pattern.compile("(.*)<(html|head|body)>(.*)", 34);

    public MailMessageBlobHolder(DocumentModel doc, String xPath, String xPathFilename) {
        super(doc, xPath, xPathFilename);
    }

    public Blob getBlob() throws ClientException {
        String htmlTextProperty = (String)((Object)this.doc.getPropertyValue(this.xPath));
        StringBlob blob = null;
        if (htmlTextProperty != null && this.xPathFilename != null && htmlTextProperty.length() != 0) {
            blob = new StringBlob(htmlTextProperty);
            Matcher m = this.isHtmlPattern.matcher(htmlTextProperty);
            if (m.matches()) {
                blob.setMimeType("text/html");
            } else {
                blob.setMimeType("text/plain");
            }
        } else {
            String txt = (String)((Object)this.doc.getPropertyValue("mail:text"));
            if (txt == null) {
                txt = "";
            }
            blob = new StringBlob(txt, "text/plain");
        }
        if (blob != null) {
            blob.setFilename(this.xPathFilename);
            blob.setDigest("notInBinaryStore");
        }
        return blob;
    }
}

