/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nuxeo.ecm.core.redis.RedisConfigurationDescriptor;
import org.nuxeo.ecm.core.redis.RedisService;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisServiceImpl
extends DefaultComponent
implements RedisService {
    private static final Log log = LogFactory.getLog(RedisServiceImpl.class);
    public static final String DEFAULT_PREFIX = "nuxeo:work:";
    protected RedisConfigurationDescriptor redisConfigurationDescriptor;
    protected JedisPool jedisPool;

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            RedisConfigurationDescriptor desc = (RedisConfigurationDescriptor)contrib;
            if (!desc.disabled) {
                this.registerConfiguration(desc);
                continue;
            }
            this.unregisterConfiguration(desc);
        }
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            RedisConfigurationDescriptor desc = (RedisConfigurationDescriptor)contrib;
            if (desc.disabled) continue;
            this.unregisterConfiguration(desc);
        }
    }

    public void registerConfiguration(RedisConfigurationDescriptor desc) {
        log.info((Object)"Registering Redis configuration");
        if (StringUtils.isBlank((String)desc.host)) {
            throw new RuntimeException("Missing Redis host");
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        String host = desc.host;
        String password = StringUtils.defaultIfBlank((String)desc.password, null);
        int port = desc.port == 0 ? 6379 : desc.port;
        int timeout = desc.timeout == 0 ? 2000 : desc.timeout;
        int database = desc.database == 0 ? 0 : desc.database;
        this.redisConfigurationDescriptor = desc;
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password, database);
    }

    public void unregisterConfiguration(RedisConfigurationDescriptor desc) {
        log.info((Object)"Unregistering Redis configuration");
        if (this.jedisPool != null) {
            this.jedisPool.destroy();
            this.jedisPool = null;
            this.redisConfigurationDescriptor = null;
        }
    }

    @Override
    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    @Override
    public String getPrefix() {
        if (this.redisConfigurationDescriptor == null) {
            return null;
        }
        String prefix = this.redisConfigurationDescriptor.prefix;
        if ("NULL".equals(prefix)) {
            prefix = "";
        } else if (StringUtils.isBlank((String)prefix)) {
            prefix = DEFAULT_PREFIX;
        }
        return prefix;
    }
}

