/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.listeners;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

public class ResizeAvatarPictureListener
implements EventListener {
    protected static final int RESIZED_IMAGE_WIDTH = 300;
    protected static final int RESIZED_IMAGE_HEIGHT = 200;

    public void handleEvent(Event event) throws ClientException {
        Blob image;
        DocumentEventContext ctx;
        DocumentModel doc;
        if (this.isBeforeUpdate(event) && (doc = (ctx = (DocumentEventContext)event.getContext()).getSourceDocument()).hasFacet("UserProfile") && (image = (Blob)doc.getPropertyValue("userprofile:avatar")) != null) {
            this.resizeAvatar(doc, image);
        }
    }

    protected boolean isBeforeUpdate(Event event) {
        return "beforeDocumentModification".equals(event.getName()) && event.getContext() instanceof DocumentEventContext;
    }

    protected void resizeAvatar(DocumentModel doc, Blob avatarImage) throws ClientException, PropertyException {
        ImagingService service;
        try {
            service = (ImagingService)Framework.getService(ImagingService.class);
        }
        catch (Exception e) {
            throw new ClientException("Failed to get ImagingService", (Throwable)e);
        }
        ImageInfo info = service.getImageInfo(avatarImage);
        int width = info.getWidth();
        int height = info.getHeight();
        float wScale = 300.0f / (float)width;
        float hscale = 200.0f / (float)height;
        float scale = Math.min(wScale, hscale);
        if (scale < 1.0f) {
            avatarImage = service.resize(avatarImage, "jpg", (int)((float)width * scale), (int)((float)height * scale), info.getDepth());
            avatarImage.setMimeType("image/jpeg");
            doc.setPropertyValue("userprofile:avatar", (Serializable)avatarImage);
        }
    }
}

