/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.handlers;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.faceted.search.jsf.FacetedSearchActions;
import org.nuxeo.ecm.platform.suggestbox.service.SearchDocumentsSuggestion;
import org.nuxeo.ecm.virtualnavigation.action.MultiNavTreeManager;

@Operation(id="Suggestion.JSF.NavigateToFacetedSearch", category="User Interface", label="Suggestion handler for navigation to faceted search view", description="Handles JSF navigation given a SearchDocumentsSuggestion as input.")
public class FacetedSearchSuggestionHandler {
    public static final String ID = "Suggestion.JSF.NavigateToFacetedSearch";

    @OperationMethod
    public Object run(Object input) throws OperationException, ClientException {
        List cvNames;
        if (!(input instanceof SearchDocumentsSuggestion)) {
            throw new OperationException(String.format("Expected an instance of SearchDocumentsSuggestion, got '%s'", input));
        }
        SearchDocumentsSuggestion suggestion = (SearchDocumentsSuggestion)input;
        MultiNavTreeManager multiNavTreeManager = (MultiNavTreeManager)Component.getInstance(MultiNavTreeManager.class);
        FacetedSearchActions facetedSearchActions = (FacetedSearchActions)Component.getInstance(FacetedSearchActions.class);
        ContentViewActions contentViewActions = (ContentViewActions)Component.getInstance(ContentViewActions.class);
        facetedSearchActions.clearSearch();
        String contentViewName = facetedSearchActions.getCurrentContentViewName();
        if (!this.impactContentView(contentViewActions, contentViewName, suggestion) && (cvNames = facetedSearchActions.getContentViewNames()) != null && cvNames.size() > 1) {
            for (String cvName : cvNames) {
                facetedSearchActions.setCurrentContentViewName(cvName);
                if (!this.impactContentView(contentViewActions, cvName, suggestion)) continue;
                break;
            }
        }
        multiNavTreeManager.setSelectedNavigationTree("facetedSearch");
        return "faceted_search_results";
    }

    protected boolean impactContentView(ContentViewActions contentViewActions, String contentViewName, SearchDocumentsSuggestion suggestion) throws ClientException {
        boolean set = false;
        ContentView contentView = contentViewActions.getContentView(contentViewName);
        DocumentModel dm = contentView.getSearchDocumentModel();
        if (dm != null) {
            for (Map.Entry searchEntry : suggestion.getSearchCriteria().entrySet()) {
                String searchField = (String)searchEntry.getKey();
                Serializable searchValue = (Serializable)searchEntry.getValue();
                try {
                    Property searchProperty = dm.getProperty(searchField);
                    if (searchProperty.isList()) {
                        dm.setPropertyValue(searchField, (Serializable)((Object)Collections.singleton(searchValue)));
                    } else {
                        dm.setPropertyValue(searchField, searchValue);
                    }
                    set = true;
                }
                catch (PropertyNotFoundException e) {}
            }
        }
        return set;
    }
}

