/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.select2.automation;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.select2.common.Select2Common;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="UserGroup.Suggestion", category="Services", label="Get user/group suggestion", description="Get the user/group list of the running instance. This is returning a blob containing a serialized JSON array..")
public class SuggestUserEntries {
    private static final Log log = LogFactory.getLog(SuggestUserEntries.class);
    public static final String ID = "UserGroup.Suggestion";
    @Context
    protected OperationContext ctx;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="prefix", required=false)
    protected String prefix;
    @Param(name="searchType", required=false)
    protected String searchType;
    @Param(name="groupRestriction", required=false)
    protected String groupRestriction;
    @Param(name="userSuggestionMaxSearchResults", required=false)
    protected Integer userSuggestionMaxSearchResults;
    @Param(name="firstLabelField", required=false)
    protected String firstLabelField;
    @Param(name="secondLabelField", required=false)
    protected String secondLabelField;
    @Param(name="thirdLabelField", required=false)
    protected String thirdLabelField;
    @Param(name="hideFirstLabel", required=false)
    protected boolean hideFirstLabel = false;
    @Param(name="hideSecondLabel", required=false)
    protected boolean hideSecondLabel = false;
    @Param(name="hideThirdLabel", required=false)
    protected boolean hideThirdLabel;
    @Param(name="displayEmailInSuggestion", required=false)
    protected boolean displayEmailInSuggestion;
    @Param(name="hideIcon", required=false)
    protected boolean hideIcon;
    @Context
    protected UserManager userManager;
    @Context
    protected DirectoryService directoryService;
    @Param(name="lang", required=false)
    protected String lang;

    @OperationMethod
    public Blob run() throws ClientException {
        JSONArray result = new JSONArray();
        boolean isGroupRestriction = !StringUtils.isBlank((String)this.groupRestriction);
        boolean groupOnly = false;
        boolean userOnly = isGroupRestriction;
        if (!isGroupRestriction && this.searchType != null && !this.searchType.isEmpty()) {
            if (this.searchType.equals("USER_TYPE")) {
                userOnly = true;
            } else if (this.searchType.equals("GROUP_TYPE")) {
                groupOnly = true;
            }
        }
        try {
            Schema schema;
            DocumentModelList userList = null;
            DocumentModelList groupList = null;
            if (!groupOnly) {
                schema = this.schemaManager.getSchema(this.userManager.getUserSchemaName());
                userList = this.userManager.searchUsers(this.prefix);
                Directory userDir = this.directoryService.getDirectory(this.userManager.getUserDirectoryName());
                for (DocumentModel user : userList) {
                    JSONObject obj = new JSONObject();
                    for (Field field : schema.getFields()) {
                        QName fieldName = field.getName();
                        String key = fieldName.getLocalName();
                        Serializable value = user.getPropertyValue(fieldName.getPrefixedName());
                        if (key.equals(userDir.getPasswordField())) continue;
                        obj.element(key, (Object)value);
                    }
                    String userId = user.getId();
                    obj.put((Object)"id", (Object)userId);
                    obj.put((Object)"type", (Object)"USER_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("user:" + userId));
                    Select2Common.computeUserLabel(obj, this.firstLabelField, this.secondLabelField, this.thirdLabelField, this.hideFirstLabel, this.hideSecondLabel, this.hideThirdLabel, this.displayEmailInSuggestion, userId);
                    Select2Common.computeUserGroupIcon(obj, this.hideIcon);
                    if (isGroupRestriction) {
                        user = this.userManager.getUserModel(userId);
                        UserAdapter userAdapter = (UserAdapter)user.getAdapter(UserAdapter.class);
                        List groups = userAdapter.getGroups();
                        if (groups == null || !groups.contains(this.groupRestriction)) continue;
                        result.add((Object)obj);
                        continue;
                    }
                    result.add((Object)obj);
                }
            }
            if (!userOnly) {
                schema = this.schemaManager.getSchema(this.userManager.getGroupSchemaName());
                groupList = this.userManager.searchGroups(this.prefix);
                for (DocumentModel group : groupList) {
                    JSONObject obj = new JSONObject();
                    for (Field field : schema.getFields()) {
                        QName fieldName = field.getName();
                        String key = fieldName.getLocalName();
                        Serializable value = group.getPropertyValue(fieldName.getPrefixedName());
                        obj.element(key, (Object)value);
                    }
                    String groupId = group.getId();
                    obj.put((Object)"id", (Object)groupId);
                    Select2Common.computeGroupLabel(obj, groupId, this.userManager.getGroupLabelField(), this.hideFirstLabel);
                    obj.put((Object)"type", (Object)"GROUP_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("group:" + groupId));
                    Select2Common.computeUserGroupIcon(obj, this.hideIcon);
                    result.add((Object)obj);
                }
            }
            int userSize = userList != null ? userList.size() : 0;
            int groupSize = groupList != null ? groupList.size() : 0;
            int totalSize = userSize + groupSize;
            if (this.userSuggestionMaxSearchResults != null && this.userSuggestionMaxSearchResults > 0 && (userSize > this.userSuggestionMaxSearchResults || groupSize > this.userSuggestionMaxSearchResults || totalSize > this.userSuggestionMaxSearchResults)) {
                throw new SizeLimitExceededException();
            }
        }
        catch (SizeLimitExceededException e) {
            return this.searchOverflowMessage();
        }
        return new StringBlob(result.toString(), "application/json");
    }

    private Blob searchOverflowMessage() {
        JSONArray result = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put((Object)"displayLabel", (Object)I18NUtils.getMessageString((String)"messages", (String)"label.security.searchOverFlow", (Object[])new Object[0], (Locale)this.getLocale()));
        result.add((Object)obj);
        return new StringBlob(result.toString(), "application/json");
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }
}

