/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleDescriptor;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleTypesDescriptor;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleRegistry;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleTypeRegistry;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class LifeCycleServiceImpl
extends DefaultComponent
implements LifeCycleService {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.lifecycle.LifeCycleService");
    private static final Log log = LogFactory.getLog(LifeCycleServiceImpl.class);
    protected LifeCycleRegistry lifeCycles = new LifeCycleRegistry();
    protected LifeCycleTypeRegistry lifeCycleTypes = new LifeCycleTypeRegistry();

    @Override
    public LifeCycle getLifeCycleByName(String name) {
        return this.lifeCycles.getLifeCycle(name);
    }

    @Override
    public LifeCycle getLifeCycleFor(Document doc) {
        String lifeCycleName = this.getLifeCycleNameFor(doc.getType().getName());
        return this.getLifeCycleByName(lifeCycleName);
    }

    @Override
    public String getLifeCycleNameFor(String typeName) {
        return this.lifeCycleTypes.getLifeCycleNameForType(typeName);
    }

    @Override
    public Collection<LifeCycle> getLifeCycles() {
        return this.lifeCycles.getLifeCycles();
    }

    @Override
    public Collection<String> getTypesFor(String lifeCycleName) {
        return this.lifeCycleTypes.getTypesFor(lifeCycleName);
    }

    @Override
    public Map<String, String> getTypesMapping() {
        return this.lifeCycleTypes.getTypesMapping();
    }

    @Override
    public void initialize(Document doc) throws LifeCycleException {
        this.initialize(doc, null);
    }

    @Override
    public void initialize(Document doc, String initialStateName) throws LifeCycleException {
        String lifeCycleName;
        LifeCycle documentLifeCycle = this.getLifeCycleFor(doc);
        if (documentLifeCycle == null) {
            lifeCycleName = "undefined";
            if (initialStateName == null) {
                initialStateName = "undefined";
            }
        } else {
            lifeCycleName = documentLifeCycle.getName();
            if (initialStateName == null) {
                initialStateName = documentLifeCycle.getDefaultInitialStateName();
            } else {
                LifeCycleState state = documentLifeCycle.getStateByName(initialStateName);
                if (state == null) {
                    throw new LifeCycleException(String.format("State '%s' is not a valid state for lifecycle %s", initialStateName, lifeCycleName));
                }
                if (!documentLifeCycle.getInitialStateNames().contains(initialStateName)) {
                    log.warn((Object)String.format("State '%s' is not a valid initial state for lifecycle %s", initialStateName, lifeCycleName));
                }
            }
        }
        doc.setCurrentLifeCycleState(initialStateName);
        doc.setLifeCyclePolicy(lifeCycleName);
    }

    @Override
    public void followTransition(Document doc, String transitionName) throws LifeCycleException {
        String lifeCycleState = doc.getLifeCycleState();
        LifeCycle lifeCycle = this.getLifeCycleFor(doc);
        if (!lifeCycle.getAllowedStateTransitionsFrom(lifeCycleState).contains(transitionName)) {
            throw new LifeCycleException("Not allowed to follow transition <" + transitionName + "> from state <" + lifeCycleState + '>');
        }
        String destinationStateName = lifeCycle.getTransitionByName(transitionName).getDestinationStateName();
        doc.setCurrentLifeCycleState(destinationStateName);
    }

    @Override
    public void reinitLifeCycle(Document doc) throws LifeCycleException {
        LifeCycle documentLifeCycle = this.getLifeCycleFor(doc);
        if (documentLifeCycle == null) {
            log.debug((Object)"No lifecycle policy for this document. Nothing to do !");
            return;
        }
        doc.setCurrentLifeCycleState(documentLifeCycle.getDefaultInitialStateName());
    }

    public void registerExtension(Extension extension) throws Exception {
        block2: {
            String point;
            Object[] contributions;
            block4: {
                block3: {
                    contributions = extension.getContributions();
                    if (contributions == null) break block2;
                    point = extension.getExtensionPoint();
                    if (!point.equals("lifecycle")) break block3;
                    for (Object contribution : contributions) {
                        LifeCycleDescriptor desc = (LifeCycleDescriptor)contribution;
                        this.lifeCycles.addContribution(desc);
                    }
                    break block2;
                }
                if (!point.equals("lifecyclemanager")) break block4;
                log.warn((Object)"Ignoring deprecated lifecyclemanager extension point");
                break block2;
            }
            if (!point.equals("types")) break block2;
            for (Object mapping : contributions) {
                LifeCycleTypesDescriptor desc = (LifeCycleTypesDescriptor)mapping;
                this.lifeCycleTypes.addContribution(desc);
            }
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        block2: {
            String point;
            Object[] contributions;
            block3: {
                super.unregisterExtension(extension);
                contributions = extension.getContributions();
                if (contributions == null) break block2;
                point = extension.getExtensionPoint();
                if (!point.equals("lifecycle")) break block3;
                for (Object lifeCycle : contributions) {
                    LifeCycleDescriptor lifeCycleDescriptor = (LifeCycleDescriptor)lifeCycle;
                    this.lifeCycles.removeContribution(lifeCycleDescriptor);
                }
                break block2;
            }
            if (!point.equals("types")) break block2;
            for (Object contrib : contributions) {
                LifeCycleTypesDescriptor desc = (LifeCycleTypesDescriptor)contrib;
                this.lifeCycleTypes.removeContribution(desc);
            }
        }
    }

    @Override
    public List<String> getNonRecursiveTransitionForDocType(String docTypeName) {
        return this.lifeCycleTypes.getNonRecursiveTransitionForDocType(docTypeName);
    }
}

