/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;

@XObject(value="repository", order={"@name"})
public class RepositoryDescriptor {
    private static final Log log = LogFactory.getLog(RepositoryDescriptor.class);
    @XNode(value="@name")
    private String name;
    @XNode(value="@factory")
    private Class<RepositoryFactory> factoryClass;
    @XNode(value="repository/pool")
    public NuxeoConnectionManagerConfiguration pool;
    private String home;
    private String config;
    @XNode(value="@forceReloadTypes")
    private boolean forceReloadTypes = false;
    private final File REPOS_DIR = new File(Framework.getRuntime().getHome(), "repos");

    public RepositoryDescriptor() {
    }

    public RepositoryDescriptor(String name, Class<RepositoryFactory> factoryClass, String home, String config, boolean forceReloadTypes) {
        this.name = name;
        this.factoryClass = factoryClass;
        this.home = home;
        this.config = config;
        this.forceReloadTypes = forceReloadTypes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHomeDirectory() {
        if (this.home == null || this.home.length() == 0) {
            File homeFile = new File(this.REPOS_DIR, this.name);
            this.home = homeFile.getAbsolutePath();
            homeFile.mkdirs();
        }
        return this.home;
    }

    public void setHomeDirectory(String home) {
        this.home = home;
    }

    public String getConfigurationFile() {
        return this.config;
    }

    @XContent
    public void setConfigurationContent(String content) {
        String homePath = this.getHomeDirectory();
        File configFile = new File(homePath, this.name + ".xml");
        this.config = configFile.getAbsolutePath();
        try {
            FileUtils.writeFile((File)configFile, (String)content);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void setConfigurationFile(String config) {
        this.config = config;
    }

    public void setFactoryClass(Class<RepositoryFactory> factoryClass) {
        this.factoryClass = factoryClass;
    }

    public Class<RepositoryFactory> getFactoryClass() {
        return this.factoryClass;
    }

    public NuxeoConnectionManagerConfiguration getPool() {
        return this.pool;
    }

    public final Repository create() throws Exception {
        return this.getFactory().createRepository(this);
    }

    public final RepositoryFactory getFactory() throws IllegalAccessException, InstantiationException {
        assert (this.factoryClass != null);
        return this.factoryClass.newInstance();
    }

    public boolean getForceReloadTypes() {
        return this.forceReloadTypes;
    }

    public void setForceReloadTypes(boolean val) {
        this.forceReloadTypes = val;
    }

    public void dispose() {
        this.factoryClass = null;
        this.name = null;
        this.home = null;
        this.config = null;
    }

    public String toString() {
        return "Repository " + this.name + " { home: " + this.home + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RepositoryDescriptor) {
            RepositoryDescriptor rd = (RepositoryDescriptor)obj;
            return this.name.equals(rd.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

