/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.service.MetadataMapper;

public class DefaultMetadataMapper
implements MetadataMapper {
    private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final TimeZone timezone = TimeZone.getDefault();

    @Override
    public void updateMetadata(Annotation annotation, NuxeoPrincipal user) {
        Calendar calendar = Calendar.getInstance();
        calendar.toString();
        annotation.addMetadata("http://purl.org/dc/elements/1.1/date", this.getStringUTCDate());
        annotation.addMetadata("http://purl.org/dc/elements/1.1/creator", user.getName());
    }

    private String getStringUTCDate() {
        Date now = new Date();
        return this.format.format(new Date(now.getTime() - (long)this.timezone.getOffset(new Date().getTime())));
    }
}

