/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.AnnotationUtils;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.i18n.TranslationMessages;

public class AnnotationListPopup
extends PopupPanel {
    public AnnotationListPopup(String annotationName, List<Annotation> annotations, WebConfiguration configuration) {
        this.setWidth(Window.getClientWidth() + " px");
        this.setHeight(Window.getClientHeight() + " px");
        this.setStyleName("annotationListPopup");
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setWidth("100%");
        HorizontalPanel titleBar = new HorizontalPanel();
        titleBar.setStyleName("annotationListPopupTitleBar");
        TranslationMessages translationMessages = (TranslationMessages)GWT.create(TranslationMessages.class);
        Label title = new Label(translationMessages.annotationListPopupTitle(annotationName));
        titleBar.add((Widget)title);
        titleBar.setCellWidth((Widget)title, "100%");
        PushButton closeButton = new PushButton(" ", new ClickListener(){

            public void onClick(Widget arg0) {
                AnnotationListPopup.this.hide();
            }
        });
        closeButton.setStyleName("annotationListPopupClose");
        titleBar.add((Widget)closeButton);
        verticalPanel.add((Widget)titleBar);
        Grid grid = new Grid(annotations.size(), 3);
        grid.setWidth("100%");
        grid.setCellSpacing(0);
        grid.setStyleName("annotationListPopupGrid");
        Set<String> displayedFields = configuration.getDisplayedFields();
        String icon = configuration.getAnnotationDefinition(annotationName).getIcon();
        for (int i = 0; i < annotations.size(); ++i) {
            grid.setWidget(i, 0, (Widget)new Image(icon));
            Annotation annotation = annotations.get(i);
            String fields = annotation.getFormattedDate();
            for (String displayedField : displayedFields) {
                String value = annotation.getFields().get(displayedField);
                if (value == null) continue;
                fields = fields + "<br/>" + value;
            }
            grid.setWidget(i, 1, (Widget)new HTML(fields));
            grid.getColumnFormatter().addStyleName(1, "annotationListPopupFields");
            String body = "";
            Set<String> definedFields = configuration.getAnnotationDefinition(annotationName).getFields().keySet();
            for (String definedField : definedFields) {
                if (displayedFields.contains(definedField)) continue;
                body = body + annotation.getFields().get(definedField) + " - ";
            }
            body = body + AnnotationUtils.replaceCarriageReturns(AnnotationUtils.escapeHtml(annotation.getBody()));
            grid.setWidget(i, 2, (Widget)new HTML(body));
            grid.getColumnFormatter().setWidth(2, "100%");
        }
        verticalPanel.add((Widget)grid);
        verticalPanel.setCellHeight((Widget)grid, "100%");
        this.add((Widget)verticalPanel);
    }
}

