/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

public class TaggedDocumentRemovedListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        if (events.containsEventName("documentRemoved") || events.containsEventName("lifecycle_transition_event")) {
            for (Event event : events) {
                String eventName = event.getName();
                if ("documentRemoved".equals(eventName)) {
                    this.handleEvent(event);
                    continue;
                }
                if (!"lifecycle_transition_event".equals(eventName) || !"deleted".equals(event.getContext().getProperty("to"))) continue;
                this.handleEvent(event);
            }
        }
    }

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc == null) {
                return;
            }
            String docId = doc.getId();
            CoreSession coreSession = docCtx.getCoreSession();
            TagService tagService = (TagService)Framework.getLocalService(TagService.class);
            tagService.removeTags(coreSession, docId);
        }
    }
}

