/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.convert;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.microdom.convert.IMicroTypeConverter;
import com.phloc.commons.microdom.convert.IMicroTypeConverterCallback;
import com.phloc.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.phloc.commons.microdom.convert.IMicroTypeConverterRegistry;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    private static final MicroTypeConverterRegistry s_aInstance = new MicroTypeConverterRegistry();
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<Class<?>, IMicroTypeConverter> s_aMap = new WeakHashMap();

    private MicroTypeConverterRegistry() {
    }

    @Override
    public void registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        MicroTypeConverterRegistry._registerMicroElementTypeConverter(clazz, iMicroTypeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (iMicroTypeConverter == null) {
            throw new NullPointerException("converter");
        }
        s_aRWLock.writeLock().lock();
        try {
            if (s_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A microtype convert for class " + clazz + " is already registered!");
            }
            for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || s_aMap.containsKey(clazz2)) continue;
                s_aMap.put(clazz2, iMicroTypeConverter);
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMicroTypeConverter getConverterToMicroElement(@Nullable Class<?> clazz) {
        s_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter iMicroTypeConverter = s_aMap.get(clazz);
            return iMicroTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMicroTypeConverter getConverterToNative(@Nonnull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("dstClass");
        }
        s_aRWLock.readLock().lock();
        try {
            Object object;
            IMicroTypeConverter iMicroTypeConverter = s_aMap.get(clazz);
            if (iMicroTypeConverter == null) {
                WeakReference weakReference;
                Class clazz2;
                object = ClassHierarchyCache.getClassHierarchyIterator(clazz).iterator();
                while (object.hasNext() && ((clazz2 = (Class)(weakReference = (WeakReference)object.next()).get()) == null || (iMicroTypeConverter = s_aMap.get(clazz2)) == null)) {
                }
            }
            object = iMicroTypeConverter;
            return object;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback iMicroTypeConverterCallback) {
        Map<Class<?>, IMicroTypeConverter> map;
        s_aRWLock.readLock().lock();
        try {
            map = ContainerHelper.newMap(s_aMap);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        for (Map.Entry<Class<?>, IMicroTypeConverter> entry : map.entrySet()) {
            if (iMicroTypeConverterCallback.call(entry.getKey(), entry.getValue()).isBreak()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int getRegisteredMicroTypeConverterCount() {
        s_aRWLock.readLock().lock();
        try {
            int n = s_aMap.size();
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (IMicroTypeConverterRegistrarSPI iMicroTypeConverterRegistrarSPI : ServiceLoaderBackport.load(IMicroTypeConverterRegistrarSPI.class)) {
            iMicroTypeConverterRegistrarSPI.registerMicroTypeConverter(s_aInstance);
        }
        s_aLogger.info(MicroTypeConverterRegistry.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
    }
}

