/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public enum EXMLParserProperty implements IHasName
{
    SAX_FEATURE_LEXICAL_HANDLER("http://xml.org/sax/properties/lexical-handler");

    private static final Logger s_aLogger;
    private final String m_sName;

    private EXMLParserProperty(String string2) {
        this.m_sName = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public void applyTo(@Nonnull XMLReader xMLReader, Object object) {
        try {
            xMLReader.setProperty(this.m_sName, object);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            s_aLogger.warn("XML Parser does not recognize property '" + this.name() + "'");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            s_aLogger.warn("XML Parser does not support property '" + this.name() + "'");
        }
    }

    @Nullable
    public static EXMLParserProperty getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EXMLParserProperty.class, string);
    }

    static {
        s_aLogger = LoggerFactory.getLogger(EXMLParserProperty.class);
    }
}

