/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.RandomAccessCharList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayCharList
extends RandomAccessCharList
implements Serializable {
    private transient char[] _data;
    private int _size;

    public ArrayCharList() {
        this(8);
    }

    public ArrayCharList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new char[n];
        this._size = 0;
    }

    public ArrayCharList(@Nonnull CharCollection charCollection) {
        this(charCollection.size());
        this.addAll(charCollection);
    }

    public ArrayCharList(@Nonnull char[] cArray) {
        this(cArray.length);
        System.arraycopy(cArray, 0, this._data, 0, cArray.length);
        this._size = cArray.length;
    }

    @Override
    public char get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public char removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        char c = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return c;
    }

    @Override
    public char set(int n, char c) {
        this._checkRange(n);
        this.incrModCount();
        char c2 = this._data[n];
        this._data[n] = c;
        return c2;
    }

    @Override
    public void add(int n, char c) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = c;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull CharCollection charCollection) {
        return this.addAll(this.size(), charCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull CharCollection charCollection) {
        if (charCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + charCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + charCollection.size(), this._size - n2);
        }
        CharIterator charIterator = charCollection.iterator();
        while (charIterator.hasNext()) {
            this._data[n2] = charIterator.next();
            ++n2;
        }
        this._size += charCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            char[] cArray = this._data;
            this._data = new char[n2 < n ? n : n2];
            System.arraycopy(cArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            char[] cArray = this._data;
            this._data = new char[this._size];
            System.arraycopy(cArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeChar(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new char[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readChar();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

