/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractBooleanCollection;
import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.BooleanIterator;
import org.apache.commons.collections.primitives.BooleanList;
import org.apache.commons.collections.primitives.BooleanListIterator;

public abstract class RandomAccessBooleanList
extends AbstractBooleanCollection
implements BooleanList {
    private int _modCount = 0;

    protected RandomAccessBooleanList() {
    }

    @Override
    public abstract boolean get(int var1);

    @Override
    public abstract int size();

    @Override
    public boolean removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean set(int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(boolean bl) {
        this.add(this.size(), bl);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull BooleanCollection booleanCollection) {
        int n2 = n;
        boolean bl = false;
        BooleanIterator booleanIterator = booleanCollection.iterator();
        while (booleanIterator.hasNext()) {
            this.add(n2++, booleanIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(boolean bl) {
        int n = 0;
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanIterator.next() == bl) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(boolean bl) {
        BooleanListIterator booleanListIterator = this.listIterator(this.size());
        while (booleanListIterator.hasPrevious()) {
            if (booleanListIterator.previous() != bl) continue;
            return booleanListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public BooleanIterator iterator() {
        return this.listIterator();
    }

    @Override
    public BooleanListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public BooleanListIterator listIterator(int n) {
        return new RandomAccessBooleanListIterator(this, n);
    }

    @Override
    public BooleanList subList(int n, int n2) {
        return new RandomAccessBooleanSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanList)) {
            return false;
        }
        BooleanList booleanList = (BooleanList)object;
        if (this.size() != booleanList.size()) {
            return false;
        }
        BooleanIterator booleanIterator = booleanList.iterator();
        BooleanIterator booleanIterator2 = this.iterator();
        while (booleanIterator2.hasNext()) {
            if (booleanIterator2.next() == booleanIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            hashCodeGenerator.append(booleanIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            stringBuilder.append(booleanIterator.next());
            if (!booleanIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessBooleanSubList
    extends RandomAccessBooleanList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessBooleanList _list = null;
        private ComodChecker _comod = null;

        RandomAccessBooleanSubList(RandomAccessBooleanList randomAccessBooleanList, int n, int n2) {
            if (n < 0 || n2 > randomAccessBooleanList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessBooleanList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessBooleanList);
            this._comod.resyncModCount();
        }

        @Override
        public boolean get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public boolean removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            boolean bl = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return bl;
        }

        @Override
        public boolean set(int n, boolean bl) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            boolean bl2 = this._list.set(this.toUnderlyingIndex(n), bl);
            this.incrModCount();
            this._comod.resyncModCount();
            return bl2;
        }

        @Override
        public void add(int n, boolean bl) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), bl);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessBooleanListIterator
    extends ComodChecker
    implements BooleanListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessBooleanListIterator(RandomAccessBooleanList randomAccessBooleanList, int n) {
            super(randomAccessBooleanList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public boolean next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            boolean bl = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return bl;
        }

        @Override
        public boolean previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            boolean bl = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return bl;
        }

        @Override
        public void add(boolean bl) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, bl);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(boolean bl) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, bl);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessBooleanList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessBooleanList randomAccessBooleanList) {
            this._source = randomAccessBooleanList;
            this.resyncModCount();
        }

        protected RandomAccessBooleanList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

