/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.adapters.AbstractByteCollectionCollection;
import org.apache.commons.collections.primitives.adapters.NonSerializableByteCollectionCollection;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class ByteCollectionCollection
extends AbstractByteCollectionCollection
implements Serializable {
    private transient ByteCollection m_aCollection;

    public ByteCollectionCollection(@Nonnull ByteCollection byteCollection) {
        this.m_aCollection = byteCollection;
    }

    @Override
    @Nonnull
    protected ByteCollection getByteCollection() {
        return this.m_aCollection;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aCollection);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aCollection = (ByteCollection)objectInputStream.readObject();
    }

    @Nullable
    public static Collection<Byte> wrap(@Nullable ByteCollection byteCollection) {
        if (null == byteCollection) {
            return null;
        }
        if (byteCollection instanceof Serializable) {
            return new ByteCollectionCollection(byteCollection);
        }
        return new NonSerializableByteCollectionCollection(byteCollection);
    }
}

