/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.decorators.BaseUnmodifiableShortList;
import org.apache.commons.collections.primitives.decorators.NonSerializableUnmodifiableShortList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class UnmodifiableShortList
extends BaseUnmodifiableShortList
implements Serializable {
    private transient ShortList m_aProxied;

    UnmodifiableShortList(@Nonnull ShortList shortList) {
        this.m_aProxied = shortList;
    }

    @Override
    @Nonnull
    protected ShortList getProxiedList() {
        return this.m_aProxied;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aProxied);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aProxied = (ShortList)objectInputStream.readObject();
    }

    @Nullable
    public static final ShortList wrap(@Nullable ShortList shortList) {
        if (null == shortList) {
            return null;
        }
        if (shortList instanceof UnmodifiableShortList) {
            return shortList;
        }
        if (shortList instanceof Serializable) {
            return new UnmodifiableShortList(shortList);
        }
        return new NonSerializableUnmodifiableShortList(shortList);
    }
}

