/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.nuxeo.ecm.core.opencmis.impl.util.ListUtils;

public class TypeManagerImpl
implements TypeManager {
    public static final int DEFAULT_MAX_TYPE_CHILDREN = 100;
    protected Map<String, TypeDefinitionContainer> typesMap = new HashMap<String, TypeDefinitionContainer>();
    protected Map<String, String> propQueryNameToId = new HashMap<String, String>();

    public TypeDefinitionContainer getTypeById(String typeId) {
        return this.typesMap.get(typeId);
    }

    public boolean hasType(String typeId) {
        return this.typesMap.containsKey(typeId);
    }

    public TypeDefinition getTypeByQueryName(String typeQueryName) {
        for (Map.Entry<String, TypeDefinitionContainer> entry : this.typesMap.entrySet()) {
            TypeDefinition type = entry.getValue().getTypeDefinition();
            if (!type.getQueryName().equals(typeQueryName)) continue;
            return type;
        }
        return null;
    }

    public TypeDefinitionList getTypeChildren(String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        ArrayList<TypeDefinitionContainer> types;
        TypeDefinitionContainer typec;
        if (typeId == null) {
            typec = null;
        } else {
            typec = this.typesMap.get(typeId);
            if (typec == null) {
                throw new CmisInvalidArgumentException("No such type: " + typeId);
            }
        }
        if (typec == null) {
            types = new ArrayList<TypeDefinitionContainer>(4);
            for (TypeDefinitionContainer tc : this.typesMap.values()) {
                if (tc.getTypeDefinition().getParentTypeId() != null) continue;
                types.add(tc);
            }
        } else {
            types = typec.getChildren();
        }
        List<TypeDefinition> list = new ArrayList(types.size());
        for (TypeDefinitionContainer tdc : types) {
            TypeDefinition type = tdc.getTypeDefinition();
            if (!Boolean.TRUE.equals(includePropertyDefinitions)) {
                type = WSConverter.convert((CmisTypeDefinitionType)WSConverter.convert((TypeDefinition)type));
                type.getPropertyDefinitions().clear();
            }
            list.add(type);
        }
        list = ListUtils.batchList(list, maxItems, skipCount, 100);
        return new TypeDefinitionListImpl(list);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String typeId, int depth, Boolean includePropertyDefinitions) {
        List<Object> types;
        boolean includeProps = Boolean.TRUE.equals(includePropertyDefinitions);
        if (typeId == null) {
            types = new ArrayList<TypeDefinitionContainer>(4);
            for (TypeDefinitionContainer tc : this.typesMap.values()) {
                if (tc.getTypeDefinition().getParentTypeId() != null) continue;
                types.add(tc);
            }
            if (!includeProps) {
                types = TypeManagerImpl.cloneTypes(types, -1, false);
            }
        } else {
            TypeDefinitionContainer typec = this.typesMap.get(typeId);
            if (typec == null) {
                throw new CmisInvalidArgumentException("No such type: " + typeId);
            }
            if (depth == 0 || depth < -1) {
                throw new CmisInvalidArgumentException("Invalid depth: " + depth);
            }
            if (depth == -1) {
                types = typec.getChildren();
                if (!includeProps) {
                    types = TypeManagerImpl.cloneTypes(types, -1, false);
                }
            } else {
                types = typec.getChildren();
                types = TypeManagerImpl.cloneTypes(types, depth - 1, includeProps);
            }
        }
        return types;
    }

    public Collection<TypeDefinitionContainer> getTypeDefinitionList() {
        ArrayList<TypeDefinitionContainer> typeRoots = new ArrayList<TypeDefinitionContainer>();
        for (TypeDefinitionContainer typeCont : this.typesMap.values()) {
            if (typeCont.getTypeDefinition().getParentTypeId() != null) continue;
            typeRoots.add(typeCont);
        }
        return typeRoots;
    }

    public List<TypeDefinitionContainer> getRootTypes() {
        ArrayList<TypeDefinitionContainer> rootTypes = new ArrayList<TypeDefinitionContainer>();
        for (TypeDefinitionContainer type : this.typesMap.values()) {
            String id = type.getTypeDefinition().getId();
            if (!BaseTypeId.CMIS_DOCUMENT.value().equals(id) && !BaseTypeId.CMIS_FOLDER.value().equals(id) && !BaseTypeId.CMIS_RELATIONSHIP.value().equals(id) && !BaseTypeId.CMIS_POLICY.value().equals(id)) continue;
            rootTypes.add(type);
        }
        return rootTypes;
    }

    public void addTypeDefinition(TypeDefinition type) {
        String id = type.getId();
        if (this.typesMap.containsKey(id)) {
            throw new RuntimeException("Type already exists: " + id);
        }
        TypeDefinitionContainerImpl typeContainer = new TypeDefinitionContainerImpl(type);
        this.typesMap.put(id, (TypeDefinitionContainer)typeContainer);
        String parentId = type.getParentTypeId();
        if (parentId != null) {
            if (!this.typesMap.containsKey(parentId)) {
                throw new RuntimeException("Cannot add type " + id + ", parent does not exist: " + parentId);
            }
            TypeDefinitionContainer parentTypeContainer = this.typesMap.get(parentId);
            parentTypeContainer.getChildren().add(typeContainer);
            Map propDefs = typeContainer.getTypeDefinition().getPropertyDefinitions();
            this.addInheritedProperties(propDefs, parentTypeContainer.getTypeDefinition());
        }
        for (PropertyDefinition pd : type.getPropertyDefinitions().values()) {
            String propId;
            String propQueryName = pd.getQueryName();
            String old = this.propQueryNameToId.put(propQueryName, propId = pd.getId());
            if (old == null || old.equals(propId)) continue;
            throw new RuntimeException("Cannot add type " + id + ", query name " + propQueryName + " already used for property id " + old);
        }
    }

    public String getPropertyIdForQueryName(TypeDefinition typeDefinition, String propQueryName) {
        for (PropertyDefinition pd : typeDefinition.getPropertyDefinitions().values()) {
            if (!pd.getQueryName().equals(propQueryName)) continue;
            return pd.getId();
        }
        return null;
    }

    public String getPropertyIdForQueryName(String propQueryName) {
        return this.propQueryNameToId.get(propQueryName);
    }

    protected void addInheritedProperties(Map<String, PropertyDefinition<?>> propDefs, TypeDefinition type) {
        TypeDefinitionContainer parentTypeContainer;
        if (type.getPropertyDefinitions() != null) {
            this.addInheritedPropertyDefinitions(propDefs, type.getPropertyDefinitions());
        }
        if ((parentTypeContainer = this.typesMap.get(type.getParentTypeId())) != null) {
            this.addInheritedProperties(propDefs, parentTypeContainer.getTypeDefinition());
        }
    }

    protected void addInheritedPropertyDefinitions(Map<String, PropertyDefinition<?>> propDefs, Map<String, PropertyDefinition<?>> superPropDefs) {
        for (PropertyDefinition<?> superPropDef : superPropDefs.values()) {
            PropertyDefinition clone = WSConverter.convert((CmisPropertyDefinitionType)WSConverter.convert(superPropDef));
            ((AbstractPropertyDefinition)clone).setIsInherited(Boolean.TRUE);
            propDefs.put(superPropDef.getId(), clone);
        }
    }

    protected static List<TypeDefinitionContainer> cloneTypes(List<TypeDefinitionContainer> types, int depth, boolean includePropertyDefinitions) {
        ArrayList<TypeDefinitionContainer> res = new ArrayList<TypeDefinitionContainer>(types.size());
        for (TypeDefinitionContainer tc : types) {
            AbstractTypeDefinition td = ((AbstractTypeDefinition)tc.getTypeDefinition()).clone();
            if (!includePropertyDefinitions) {
                td.setPropertyDefinitions(null);
            }
            TypeDefinitionContainerImpl clone = new TypeDefinitionContainerImpl((TypeDefinition)td);
            if (depth != 0) {
                clone.setChildren(TypeManagerImpl.cloneTypes(tc.getChildren(), depth - 1, includePropertyDefinitions));
            }
            res.add((TypeDefinitionContainer)clone);
        }
        return res;
    }
}

