/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheGCManager;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;

public class GCTask
implements Runnable {
    public static boolean GCEnabled = false;
    private static long GCInterval = 0L;
    private static final Log log = LogFactory.getLog(GCTask.class);

    public static long getGCIntervalInMinutes() {
        if (GCInterval == 0L) {
            GCInterval = ConversionServiceImpl.getGCIntervalInMinutes();
            log.debug((Object)("GC interval set to " + GCInterval));
        }
        return GCInterval;
    }

    public static void setGCIntervalInMinutes(long interval) {
        GCInterval = interval;
    }

    @Override
    public void run() {
        log.debug((Object)"starting GC thread");
        while (GCEnabled) {
            ConversionCacheGCManager.gcIfNeeded();
            try {
                long gcInterval = GCTask.getGCIntervalInMinutes();
                if (gcInterval < 0L) {
                    log.debug((Object)("GC sleeps for " + -gcInterval));
                    Thread.sleep(-gcInterval);
                    continue;
                }
                log.debug((Object)("GC sleeps for " + gcInterval * 60L * 1000L));
                Thread.sleep(gcInterval * 60L * 1000L);
            }
            catch (InterruptedException e) {
                GCEnabled = false;
                log.info((Object)"GCThread bruttaly interupted");
            }
        }
    }
}

