/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.extension;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="configuration")
public class GlobalConfigDescriptor
implements Serializable {
    public static final long DEFAULT_GC_INTERVAL_IN_MIN = 10L;
    public static final int DEFAULT_DISK_CACHE_IN_KB = 10240;
    private static final String CACHING_DIRECTORY = "convertcache";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GlobalConfigDescriptor.class);
    @XNode(value="gcInterval")
    protected long GCInterval;
    @XNode(value="diskCacheSize")
    protected int diskCacheSize;
    @XNode(value="enableCache")
    protected boolean enableCache = true;
    @XNode(value="cachingDirectory")
    protected String cachingDirectory;

    public long getGCInterval() {
        if (this.GCInterval == 0L) {
            return 10L;
        }
        return this.GCInterval;
    }

    public int getDiskCacheSize() {
        if (this.diskCacheSize == 0) {
            return 10240;
        }
        return this.diskCacheSize;
    }

    public boolean isCacheEnabled() {
        return this.enableCache;
    }

    public void update(GlobalConfigDescriptor other) {
        if (other.GCInterval != 0L) {
            this.GCInterval = other.GCInterval;
        }
        if (other.diskCacheSize != 0) {
            this.diskCacheSize = other.diskCacheSize;
        }
        if (other.cachingDirectory != null) {
            this.cachingDirectory = other.cachingDirectory;
        }
        this.enableCache = other.enableCache;
    }

    public String getCachingDirectory() {
        if (this.cachingDirectory == null) {
            File cacheFile = new File(System.getProperty("java.io.tmpdir"), CACHING_DIRECTORY);
            if (cacheFile.exists() && !cacheFile.canWrite()) {
                log.debug((Object)"change directory to avoid FileNotFoundException (permission denied)");
                try {
                    cacheFile = File.createTempFile(CACHING_DIRECTORY, null, cacheFile.getParentFile());
                    cacheFile.delete();
                }
                catch (IOException e) {
                    log.error((Object)"Could not create caching directory", (Throwable)e);
                }
            }
            cacheFile.mkdirs();
            this.cachingDirectory = cacheFile.getPath();
        }
        return this.cachingDirectory;
    }
}

