/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryService;
import org.nuxeo.ecm.platform.annotations.service.AnnotabilityManager;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class RepositoryAnnotabilityManager
implements AnnotabilityManager {
    private static final Log log = LogFactory.getLog(RepositoryAnnotabilityManager.class);
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();
    private AnnotationsRepositoryService service;

    public RepositoryAnnotabilityManager() {
        try {
            this.service = (AnnotationsRepositoryService)Framework.getService(AnnotationsRepositoryService.class);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public boolean isAnnotable(URI uri) throws AnnotationException {
        boolean bl;
        block8: {
            DocumentView view = this.translator.getDocumentViewFromUri(uri);
            if (view == null) {
                try {
                    return this.service.isAnnotable(null);
                }
                catch (ClientException e) {
                    throw new AnnotationException((Throwable)e);
                }
            }
            CoreSession session = null;
            try {
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                session = mgr.getDefaultRepository().open();
                DocumentModel model = session.getDocument(view.getDocumentLocation().getDocRef());
                bl = this.service.isAnnotable(model);
                if (session == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw new AnnotationException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        CoreInstance.getInstance().close(session);
                    }
                    throw throwable;
                }
            }
            CoreInstance.getInstance().close(session);
        }
        return bl;
    }
}

