/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlobHolder
implements BlobHolder {
    @Override
    public abstract Blob getBlob() throws ClientException;

    @Override
    public void setBlob(Blob blob) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Blob> getBlobs() throws ClientException {
        ArrayList<Blob> blobs = null;
        Blob blob = this.getBlob();
        if (blob != null) {
            blobs = new ArrayList<Blob>();
            blobs.add(blob);
        }
        return blobs;
    }

    protected abstract String getBasePath();

    @Override
    public String getFilePath() throws ClientException {
        String path = this.getBasePath();
        Blob blob = this.getBlob();
        if (blob != null) {
            path = path + "/" + blob.getFilename();
        }
        return path;
    }

    @Override
    public String getHash() throws ClientException {
        Blob blob = this.getBlob();
        if (blob != null) {
            String h = blob.getDigest();
            if (h != null) {
                return h;
            }
            return Integer.toString(blob.hashCode());
        }
        return "NullBlob";
    }

    @Override
    public abstract Calendar getModificationDate() throws ClientException;
}

