/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultBlob;

public class ByteArrayBlob
extends DefaultBlob
implements Serializable {
    private static final long serialVersionUID = -91800812783051025L;
    protected final byte[] content;

    public ByteArrayBlob(byte[] content) {
        this(content, null, null);
    }

    public ByteArrayBlob(byte[] content, String ctype) {
        this(content, ctype, null);
    }

    public ByteArrayBlob(byte[] content, String ctype, String encoding) {
        this(content, ctype, encoding, null, null);
    }

    public ByteArrayBlob(byte[] content, String mimeType, String encoding, String filename, String digest) {
        this.content = content;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.filename = filename;
        this.digest = digest;
    }

    public long getLength() {
        if (this.content == null || this.content.length == 0) {
            return 0L;
        }
        return this.content.length;
    }

    public InputStream getStream() throws IOException {
        if (this.content == null || this.content.length == 0) {
            return EMPTY_INPUT_STREAM;
        }
        return new ByteArrayInputStream(this.content);
    }

    public byte[] getByteArray() throws IOException {
        if (this.content == null || this.content.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content;
    }

    public String getString() throws IOException {
        if (this.content == null || this.content.length == 0) {
            return "";
        }
        return new String(this.content, this.encoding == null ? "UTF-8" : this.encoding);
    }

    public Reader getReader() throws IOException {
        String str = this.getString();
        if (str == null || str.length() == 0) {
            return EMPTY_READER;
        }
        return new StringReader(str);
    }

    public Blob persist() throws IOException {
        return this;
    }

    public boolean isPersistent() {
        return true;
    }
}

