/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm.util;

import java.lang.reflect.Method;
import org.nuxeo.ecm.core.api.model.impl.osm.util.AccessException;
import org.nuxeo.ecm.core.api.model.impl.osm.util.MemberAccessor;
import org.nuxeo.ecm.core.api.model.impl.osm.util.ObjectAccessorHelper;
import org.nuxeo.ecm.core.api.model.impl.osm.util.ReadOnlyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAccessor
implements MemberAccessor {
    private static final long serialVersionUID = 8937769086103552264L;
    private final Method setter;
    private final Method getter;

    public MethodAccessor(Method getter, Method setter) {
        this.setter = setter;
        this.getter = getter;
        if (setter != null && !setter.isAccessible()) {
            setter.setAccessible(true);
        }
        if (!getter.isAccessible()) {
            getter.setAccessible(true);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.setter == null;
    }

    @Override
    public Object get(Object instance) throws AccessException {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new AccessException("Failed to read field: " + this.getter, e);
        }
    }

    @Override
    public void set(Object instance, Object value) throws AccessException {
        if (this.isReadOnly()) {
            throw new ReadOnlyAccessException("Attempted to write on a read only field: " + ObjectAccessorHelper.getPropertyName(this.getter.getName()));
        }
        try {
            this.setter.invoke(instance, value);
        }
        catch (Exception e) {
            throw new AccessException("Failed to write field: " + this.setter, e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.getter.getReturnType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getter.getDeclaringClass();
    }

    public Method getSetterMethod() {
        return this.setter;
    }

    public Method getGetterMethod() {
        return this.getter;
    }
}

