/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.operation;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.operation.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationSet
implements Serializable,
Iterable<Modification> {
    private static final long serialVersionUID = 6074152814184873084L;
    private static final int SIZE = 4;
    private Modification[] ar = new Modification[4];
    private int length = 0;

    public int size() {
        return this.length;
    }

    public boolean add(DocumentRef ref, int modifType) {
        if (this.length == this.ar.length) {
            Modification[] tmp = new Modification[this.ar.length + 4];
            System.arraycopy(this.ar, 0, tmp, 0, this.ar.length);
            this.ar = tmp;
        }
        this.ar[this.length++] = new Modification(ref, modifType);
        return false;
    }

    public boolean add(Modification modif) {
        return this.add(modif.ref, modif.type);
    }

    public boolean contains(DocumentRef ref) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.ar[i].ref.equals(ref)) continue;
            return true;
        }
        return false;
    }

    public final Modification get(int index) {
        return this.ar[index];
    }

    @Deprecated
    public Modification getModification(DocumentRef ref) {
        Modification m = null;
        for (int i = 0; i < this.length; ++i) {
            if (!this.ar[i].ref.equals(ref)) continue;
            if (m == null) {
                m = new Modification(ref, this.ar[i].type);
                continue;
            }
            m.type |= this.ar[i].type;
        }
        return m;
    }

    @Deprecated
    public Modification getModifcation(DocumentRef ref) {
        return this.getModification(ref);
    }

    public int indexOf(DocumentRef ref) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.ar[i].ref.equals(ref)) continue;
            return i;
        }
        return -1;
    }

    public Modification remove(int index) {
        if (index >= this.length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Modification mod = this.ar[index];
        if (index == this.length - 1) {
            this.ar[--this.length] = null;
        } else {
            System.arraycopy(this.ar, index + 1, this.ar, index, this.ar.length - index - 1);
            --this.length;
        }
        return mod;
    }

    @Deprecated
    public Modification removeModification(DocumentRef ref) {
        Modification m = new Modification(ref, 0);
        int index = -1;
        while ((index = this.indexOf(ref)) != -1) {
            m.type |= this.remove((int)index).type;
        }
        return m;
    }

    public Modification[] toArray() {
        Modification[] tmp = new Modification[this.length];
        System.arraycopy(this.ar, 0, tmp, 0, this.ar.length);
        return tmp;
    }

    @Override
    public Iterator<Modification> iterator() {
        return new ModifIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModifIterator
    implements Iterator<Modification> {
        int index = 0;

        ModifIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ModificationSet.this.length;
        }

        @Override
        public Modification next() {
            try {
                return ModificationSet.this.ar[this.index++];
            }
            catch (Throwable t) {
                throw new NoSuchElementException("Iterator has no more elements");
            }
        }

        @Override
        public void remove() {
            ModificationSet.this.remove(this.index);
        }
    }
}

