/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository.impl;

import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.DocumentProvider;
import org.nuxeo.ecm.core.api.repository.cache.DocumentModelCache;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentProviderManager
extends DefaultComponent
implements DocumentProvider {
    private final Map<String, DocumentModel> cache = new Hashtable<String, DocumentModel>();
    private final Map<DocumentRef, String> refs = new Hashtable<DocumentRef, String>();
    private CoreSession session;

    public void setSession(CoreSession session) {
        this.session = session;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public void removeDocumentFromCache(String id) {
        this.cache.remove(id);
    }

    public void removeDocumentFromCache(DocumentRef ref) {
        ((DocumentModelCache)((Object)this.session)).uncacheDocument(ref);
    }

    public DocumentModel getCachedDocument(String id) {
        return ((DocumentModelCache)((Object)this.session)).getCachedDocument(new IdRef(id));
    }

    public DocumentModel getCachedDocument(DocumentRef ref) {
        return ((DocumentModelCache)((Object)this.session)).getCachedDocument(ref);
    }

    private DocumentModel cacheDocument(DocumentModel docModel) {
        return ((DocumentModelCache)((Object)this.session)).cacheDocument(docModel);
    }

    private DocumentModel cacheDocument(DocumentRef docRef, DocumentModel docModel) {
        System.err.println("#################### SHOULD NOT PASS HERE #################");
        return ((DocumentModelCache)((Object)this.session)).cacheDocument(docModel);
    }

    private DocumentModelList cacheDocumentList(DocumentModelList docList) {
        int length = docList.size();
        for (int i = 0; i < length; ++i) {
            DocumentModel docModel = (DocumentModel)docList.get(i);
            DocumentModel cachedDocModel = this.cacheDocument(docModel);
            if (cachedDocModel == docModel) continue;
            docList.set(i, cachedDocModel);
        }
        return docList;
    }

    public DocumentModel getDocument(String id) throws ClientException {
        return this.getDocument(id);
    }

    public DocumentModel getDocument(DocumentRef docRef) throws ClientException {
        return this.session.getDocument(docRef);
    }

    public DocumentModel getDocument(String id, boolean force) throws ClientException {
        return this.getDocument((DocumentRef)new IdRef(id), force);
    }

    public DocumentModel getDocument(DocumentRef docRef, boolean force) throws ClientException {
        if (force) {
            return ((DocumentModelCache)((Object)this.session)).fetchDocument(docRef);
        }
        return this.session.getDocument(docRef);
    }

    public DocumentModel getDocument(DocumentRef docRef, String[] schemas) throws ClientException {
        return this.session.getDocument(docRef);
    }

    public DocumentModel getRootDocument() throws ClientException {
        return this.session.getRootDocument();
    }

    public boolean exists(DocumentRef docRef) throws ClientException {
        return this.session.exists(docRef);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type) throws ClientException {
        return this.session.getChildren(parent, type);
    }

    public DocumentModelList getChildren(DocumentRef parent) throws ClientException {
        return this.session.getChildren(parent);
    }

    public DocumentModel getChild(DocumentRef parent, String name) throws ClientException {
        return this.session.getChild(parent, name);
    }

    public DocumentModel getParentDocument(DocumentRef docRef) throws ClientException {
        return this.session.getParentDocument(docRef);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent) throws ClientException {
        return this.session.getChildrenIterator(parent);
    }
}

