/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.UserAccess;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACPImpl
implements ACP {
    private static final long serialVersionUID = -2640696060701197284L;
    private final ArrayList<String> owners = new ArrayList();
    private final List<ACL> acls = new ArrayList<ACL>();
    private transient Map<String, Access> cache = new HashMap<String, Access>();

    @Override
    public String[] getOwners() {
        return this.owners.toArray(new String[this.owners.size()]);
    }

    @Override
    public boolean isOwner(String username) {
        return this.owners.contains(username);
    }

    @Override
    public void addOwner(String owner) {
        this.owners.add(owner);
        this.cache.clear();
    }

    @Override
    public void removeOwner(String owner) {
        this.owners.remove(owner);
        this.cache.clear();
    }

    @Override
    public void setOwners(String[] owners) {
        this.owners.clear();
        this.owners.addAll(Arrays.asList(owners));
        this.cache.clear();
    }

    @Override
    public void addACL(ACL acl) {
        assert (acl != null);
        ACL oldACL = this.getACL(acl.getName());
        if (!acl.equals(oldACL)) {
            if (oldACL != null) {
                oldACL.clear();
                oldACL.addAll(acl);
            } else {
                this.acls.add(acl);
            }
        }
        this.cache.clear();
    }

    @Override
    public void addACL(int pos, ACL acl) {
        this.acls.add(pos, acl);
        this.cache.clear();
    }

    @Override
    public void addACL(String afterMe, ACL acl) {
        if (afterMe == null) {
            this.addACL(0, acl);
        } else {
            int i;
            int len = this.acls.size();
            for (i = 0; i < len && !this.acls.get(i).getName().equals(afterMe); ++i) {
            }
            this.addACL(i + 1, acl);
        }
    }

    @Override
    public ACL getACL(String name) {
        if (name == null) {
            name = "local";
        }
        int len = this.acls.size();
        for (int i = 0; i < len; ++i) {
            ACL acl = this.acls.get(i);
            if (!acl.getName().equals(name)) continue;
            return acl;
        }
        return null;
    }

    @Override
    public ACL[] getACLs() {
        return this.acls.toArray(new ACL[this.acls.size()]);
    }

    @Override
    public ACL getMergedACLs(String name) {
        ACLImpl mergedAcl = new ACLImpl(name, true);
        for (ACL acl : this.acls) {
            mergedAcl.addAll(acl);
        }
        return mergedAcl;
    }

    public static ACL newACL(String name) {
        return new ACLImpl(name);
    }

    @Override
    public ACL removeACL(String name) {
        int len = this.acls.size();
        for (int i = 0; i < len; ++i) {
            ACL acl = this.acls.get(i);
            if (!acl.getName().equals(name)) continue;
            this.cache.clear();
            return this.acls.remove(i);
        }
        return null;
    }

    @Override
    public Access getAccess(String principal, String permission) {
        String key = principal + ':' + permission;
        Access access = this.cache.get(key);
        if (access == null) {
            access = Access.UNKNOWN;
            block0: for (ACL acl : this.acls) {
                for (ACE ace : acl) {
                    if (!ACPImpl.permissionsMatch(ace, permission) || !ACPImpl.principalsMatch(ace, principal)) continue;
                    access = ace.isGranted() ? Access.GRANT : Access.DENY;
                    break block0;
                }
            }
            this.cache.put(key, access);
        }
        return access;
    }

    @Override
    public Access getAccess(String[] principals, String[] permissions) {
        for (ACL acl : this.acls) {
            for (ACE ace : acl) {
                Access access = ACPImpl.getAccess(ace, principals, permissions);
                if (access == Access.UNKNOWN) continue;
                return access;
            }
        }
        return Access.UNKNOWN;
    }

    public static Access getAccess(ACE ace, String[] principals, String[] permissions) {
        String acePerm = ace.getPermission();
        String aceUser = ace.getUsername();
        for (String principal : principals) {
            if (!ACPImpl.principalsMatch(aceUser, principal)) continue;
            for (String permission : permissions) {
                if (!ACPImpl.permissionsMatch(acePerm, permission)) continue;
                return ace.isGranted() ? Access.GRANT : Access.DENY;
            }
        }
        return Access.UNKNOWN;
    }

    private static boolean permissionsMatch(ACE ace, String permission) {
        String acePerm = ace.getPermission();
        if (!permission.equals("RestrictedRead") && acePerm.equals("Everything")) {
            return true;
        }
        return acePerm.equals(permission);
    }

    private static boolean permissionsMatch(String acePerm, String permission) {
        if (acePerm.equals("Everything") && !permission.equals("RestrictedRead")) {
            return true;
        }
        return acePerm.equals(permission);
    }

    private static boolean principalsMatch(ACE ace, String principal) {
        String acePrincipal = ace.getUsername();
        if (acePrincipal.equals("Everyone")) {
            return true;
        }
        return acePrincipal.equals(principal);
    }

    private static boolean principalsMatch(String aceUser, String principal) {
        if (aceUser.equals("Everyone")) {
            return true;
        }
        return aceUser.equals(principal);
    }

    public void addAccessRule(String aclName, ACE ace) {
        ACL acl = this.getACL(aclName);
        if (acl == null) {
            acl = new ACLImpl(aclName);
            this.addACL(acl);
        }
        acl.add(ace);
    }

    @Override
    public ACL getOrCreateACL(String name) {
        ACL acl = this.getACL(name);
        if (acl == null) {
            acl = new ACLImpl(name);
            this.addACL(acl);
        }
        return acl;
    }

    @Override
    public ACL getOrCreateACL() {
        return this.getOrCreateACL("local");
    }

    @Override
    public void setRules(String aclName, UserEntry[] userEntries) {
        this.setRules(aclName, userEntries, true);
    }

    @Override
    public void setRules(String aclName, UserEntry[] userEntries, boolean overwrite) {
        ACL acl = this.getACL(aclName);
        if (acl == null) {
            acl = new ACLImpl(aclName);
            this.addACL(acl);
        } else if (overwrite) {
            acl.clear();
        }
        for (UserEntry entry : userEntries) {
            for (String permission : entry.getPermissions()) {
                UserAccess userAccess = entry.getAccess(permission);
                if (userAccess.isReadOnly()) continue;
                ACE ace = new ACE(entry.getUserName(), permission, userAccess.isGranted());
                acl.add(ace);
            }
        }
        this.cache.clear();
    }

    @Override
    public void setRules(UserEntry[] userEntries) {
        this.setRules("local", userEntries);
    }

    @Override
    public void setRules(UserEntry[] userEntries, boolean overwrite) {
        this.setRules("local", userEntries, overwrite);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.cache = new HashMap<String, Access>();
    }

    @Override
    public String[] listUsernamesForPermission(String perm) {
        ArrayList<String> usernames = new ArrayList<String>();
        ACL merged = this.getMergedACLs("merged");
        for (ACE ace : merged.getACEs()) {
            String username;
            if (!ace.getPermission().equals(perm) || !ace.isGranted() || usernames.contains(username = ace.getUsername())) continue;
            usernames.add(ace.getUsername());
        }
        return usernames.toArray(new String[usernames.size()]);
    }

    @Override
    public String[] listUsernamesForAnyPermission(Set<String> perms) {
        ArrayList<String> usernames = new ArrayList<String>();
        ACL merged = this.getMergedACLs("merged");
        for (ACE ace : merged.getACEs()) {
            String username;
            if (!perms.contains(ace.getPermission()) || !ace.isGranted() || usernames.contains(username = ace.getUsername())) continue;
            usernames.add(username);
        }
        return usernames.toArray(new String[usernames.size()]);
    }

    @Override
    public Object clone() {
        ACPImpl copy = new ACPImpl();
        for (ACL acl : this.acls) {
            copy.acls.add((ACL)acl.clone());
        }
        copy.owners.addAll((Collection)this.owners.clone());
        return copy;
    }
}

