/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.tree;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.tree.DocumentTreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDocumentTreeFilter
implements DocumentTreeFilter {
    private static final long serialVersionUID = 1L;
    protected List<String> includedFacets;
    protected List<String> excludedFacets;
    protected List<String> excludedTypes;

    @Override
    public boolean accept(DocumentModel document) {
        String docType = document.getType();
        if (this.excludedTypes != null && this.excludedTypes.contains(docType)) {
            return false;
        }
        try {
            if ("deleted".equals(document.getCurrentLifeCycleState())) {
                return false;
            }
        }
        catch (ClientException e) {
            return false;
        }
        if (this.excludedFacets != null) {
            for (String exc : this.excludedFacets) {
                if (!document.hasFacet(exc)) continue;
                return false;
            }
        }
        if (this.includedFacets != null) {
            for (String req : this.includedFacets) {
                if (document.hasFacet(req)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> getIncludedFacets() {
        return this.includedFacets;
    }

    @Override
    public void setIncludedFacets(List<String> includedFacets) {
        this.includedFacets = includedFacets;
    }

    @Override
    public List<String> getExcludedFacets() {
        return this.excludedFacets;
    }

    @Override
    public void setExcludedFacets(List<String> excludedFacets) {
        this.excludedFacets = excludedFacets;
    }

    @Override
    public List<String> getExcludedTypes() {
        return this.excludedTypes;
    }

    @Override
    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }
}

