/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.url.nxobj;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.nuxeo.ecm.core.url.nxobj.ObjectURL;

public class ObjectURLConnection
extends URLConnection {
    protected Object obj;

    public ObjectURLConnection(URL url) {
        super(url);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.obj = ObjectURL.getObject(this.url);
        if (this.obj == null) {
            throw new FileNotFoundException("Object was not found for url: " + this.url.toString());
        }
        this.connected = true;
    }

    public long getLastModified() {
        try {
            this.connect();
            return this.lastModified();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return new FilterInputStream(this.openStream()){

            public void close() throws IOException {
                super.close();
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    protected long lastModified() throws IOException {
        return -1L;
    }

    protected InputStream openStream() throws IOException {
        if (this.obj instanceof InputStream) {
            return (InputStream)this.obj;
        }
        return new ByteArrayInputStream(this.obj.toString().getBytes());
    }

    protected void close() {
        ObjectURL.removeURL(this.url);
        this.obj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

